from typing import Union

import json

import json
import re

def extract_from_model_output(content, content_type='json'):
    """
    Extracts code or content of a specific type (e.g., json, markdown, python) 
    enclosed within triple backticks (```) based on the content_type.

    Parameters:
    - content (str): The text containing the content to extract.
    - content_type (str): The type of block to extract (e.g., 'json', 'python', 'markdown').

    Returns:
    - The extracted content as a string or parsed JSON object (if content_type is 'json').
      Returns an empty string if no matching block is found.
    """
    # Ensure content_type is properly formatted
    content_type = content_type.lower()

    if content_type == 'markdown' or content_type == 'json':
        pattern = re.compile(
            rf"```{content_type}(.*)```",  # greedy match for markdown because of nested markdown blocks possible
            re.DOTALL  # Matches across newlines
        )
    else:
        pattern = re.compile(
            rf"```{content_type}(.*?)```",  # non-greedy match for other content types
            re.DOTALL  # Matches across newlines
        )
    
    # Search for all matches in the content
    match = pattern.search(content)
    if match:
        extracted = match.group(1).strip()  # Extract the captured group (content inside the block)

        # if content_type == 'json':
        #     try:
        #         # If content is JSON, parse it
        #         return json.loads(extracted)
        #     except json.JSONDecodeError:
        #         print(f"Invalid JSON content inside the block: {extracted}")
        #         raise ValueError("Invalid JSON content inside the block.")
        # else:
        #     # For other types, return the extracted raw content
        return extracted

    # If no matching block is found, return an empty string
    return ""