import turtle

rare_color_to_hex = {
    "": "#ffffff",
    "light blue": "#add8e6",
    "light coral": "#f08080",
    "light cyan": "#e0ffff",
    "light goldenrod yellow": "#fafad2",
    "light gray": "#d3d3d3",
    "light green": "#90ee90",
    "light pink": "#ffb6c1",
    "light salmon": "#ffa07a",
    "light sea green": "#20b2aa",
    "light sky blue": "#87cefa",
    "light slate gray": "#778899",
    "light steel blue": "#b0c4de",
    "light yellow": "#ffffe0",
    "medium aquamarine": "#66cdaa",
    "medium blue": "#0000cd",
    "medium orchid": "#ba55d3",
    "medium purple": "#9370db",
    "medium sea green": "#3cb371",
    "medium slate blue": "#7b68ee",
    "medium spring green": "#00fa9a",
    "medium turquoise": "#48d1cc",
    "medium violet red": "#c71585",
    "midnight blue": "#191970",
    "mint cream": "#f5fffa",
    "misty rose": "#ffe4e1",
    "moccasin": "#ffe4b5",
    "navajo white": "#ffdead",
    "old lace": "#fdf5e6",
    "pale goldenrod": "#eee8aa",
    "pale green": "#98fb98",
    "pale turquoise": "#afeeee",
    "pale violet red": "#db7093",
    "papaya whip": "#ffefd5",
    "peach puff": "#ffdab9",
    "powder blue": "#b0e0e6",
    "rosy brown": "#bc8f8f",
    "royal blue": "#4169e1",
    "saddle brown": "#8b4513",
    "sandy brown": "#f4a460",
    "sea green": "#2e8b57",
    "seashell": "#fff5ee",
    "slate blue": "#6a5acd",
    "slate gray": "#708090",
    "snow": "#fffafa",
    "spring green": "#00ff7f",
    "steel blue": "#4682b4",
    "thistle": "#d8bfd8",
    "tomato": "#ff6347",
    "turquoise": "#40e0d0",
    "violet": "#ee82ee",
    "wheat": "#f5deb3",
    "white smoke": "#f5f5f5",
    "yellow green": "#9acd32",
    "antique white": "#faebd7",
    "aquamarine": "#7fffd4",
    "azure": "#f0ffff",
    "bisque": "#ffe4c4",
    "blanched almond": "#ffebcd",
    "blue violet": "#8a2be2",
    "burly wood": "#deb887",
    "cadet blue": "#5f9ea0",
    "cornflower blue": "#6495ed",
    "cornsilk": "#fff8dc",
    "dark goldenrod": "#b8860b",
    "dark gray": "#a9a9a9",
    "dark blue": "#00008b",
    "dark green": "#006400",
    "dark khaki": "#bdb76b",
    "dark olive green": "#556b2f",
    "dark orange": "#ff8c00",
    "dark orchid": "#9932cc",
    "dark salmon": "#e9967a",
    "dark sea green": "#8fbc8f",
    "dark slate blue": "#483d8b",
    "dark slate gray": "#2f4f4f",
    "dark turquoise": "#00ced1",
    "dark violet": "#9400d3",
    "deep pink": "#ff1493",
    "deep sky blue": "#00bfff",
    "dim gray": "#696969",
    "dodger blue": "#1e90ff",
    "floral white": "#fffaf0",
    "forest green": "#228b22",
    "ghost white": "#f8f8ff",
    "green yellow": "#adff2f",
    "honeydew": "#f0fff0",
    "hot pink": "#ff69b4",
    "indian red": "#cd5c5c",
    "ivory": "#fffff0",
    "khaki": "#f0e68c",
    "lavender": "#e6e6fa",
    "lavender blush": "#fff0f5",
    "lawn green": "#7cfc00",
    "lemon chiffon": "#fffacd",
    "lime green": "#32cd32",
    "linen": "#faf0e6",
    "medium slate gray": "#7b68ee",
    "navy blue": "#000080",
    "olive drab": "#6b8e23",
    "orange red": "#ff4500",
    "peru": "#cd853f",
    "pink": "#ffc0cb",
    "plum": "#dda0dd",
    "rebecca purple": "#663399",
    "salmon": "#fa8072",
    "sienna": "#a0522d",
    "sky blue": "#87ceeb",
    "tan": "#d2b48c",
    "web gray": "#808080",
    "web green": "#008000",
    "web maroon": "#800000",
    "web purple": "#800080",
}

class XTurtle(turtle.RawTurtle):
    """
    A custom turtle class that tracks the lines drawn by the turtle.
    """
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        # List to store each line's start and end points, along with properties
        self.states = []
        self.current_position = self.position()
        # Add tracking for fill operations
        self.filling_vertices = []
        self._filling = False
        # Add a list to store lines during fill operation
        self._fill_lines = []

    def begin_fill(self):
        self._filling = True
        self.filling_vertices = [self.position()]
        # Initialize empty list for lines drawn during fill
        self._fill_lines = []
        super().begin_fill()

    def end_fill(self):
        if self._filling:
            self.filling_vertices.append(self.position())
            # Convert fillcolor to hex before storing
            fill_color = self._convert_color_to_hex(self.fillcolor())
            
            self.states.append({
                "type": "fill",
                "vertices": self.filling_vertices.copy(),
                "fillcolor": fill_color,
                "lines": self._fill_lines.copy()  # Include all lines drawn during fill
            })
        self._filling = False
        self.filling_vertices = []
        self._fill_lines = []
        super().end_fill()

    def _goto(self, end):
        if self.isdown():   
            # Convert color values to hex strings before storing
            pen_color = self._convert_color_to_hex(self.pencolor())
            fill_color = self._convert_color_to_hex(self.fillcolor())
            
            line_properties = {
                "type": "line",
                "start": self.current_position,
                "end": end,
                "pencolor": pen_color,
                "pensize": self.pensize(),
                "fillcolor": fill_color,
                "speed": self.speed(),
            }
            
            if self._filling:
                # If we're filling, add the line to fill_lines instead of states
                self._fill_lines.append(line_properties)
            else:
                # If we're not filling, add to states as usual
                self.states.append(line_properties)
            
        if self._filling:
            self.filling_vertices.append(end)
        self.current_position = end
        super()._goto(end)

    def _convert_color_to_hex(self, color):
        """
        Convert any color format to hex string for consistent serialization.

        Examples:
            >>> self._convert_color_to_hex("red")
            "red"
            >>> self._convert_color_to_hex("light blue")
            "#add8e6"
            >>> self._convert_color_to_hex((1, 0, 0))
            "#010000"
            >>> self._convert_color_to_hex((255, 0, 0))
            "#ff0000"
            >>> self._convert_color_to_hex((1.0, 0.0, 0.0))
            "#ff0000"
        """
        if isinstance(color, str):
            # Check if the color name is in the rare color mapping
            return rare_color_to_hex.get(color.lower(), color)  # Return hex if found, else return the name
        if isinstance(color, tuple):
            # Handle both RGB float (0-1) and int (0-255) formats
            r, g, b = color
            if all(isinstance(c, float) and 0 <= c <= 1 for c in color):
                # Convert float values to ints
                r = int(r * 255)
                g = int(g * 255)
                b = int(b * 255)
            return "#{:02x}{:02x}{:02x}".format(r, g, b)
        return color  # Return as-is if not recognized

    def get_turtle_states(self):
        # return all symbolic information of the turtle
        return {
            "states": self.states,
        }