from src.turtlegfx.utils.img_utils import compare_images
from src.turtlegfx.emulate.emulator import Executor
from PIL import Image

"""
This script contains functions for pixel-wise comparison of two images.
"""

def compare_pixels_from_code(code1, code2):
    image1, result1 = Executor().run(code=code1, show_screen=False)
    image2, result2 = Executor().run(code=code2, show_screen=False)
    assert result1['status'] == 'success' and result2['status'] == 'success', "Both codes must execute successfully"
    is_equal = compare_images(image1, image2)
    return is_equal


def compare_pixels_from_image(image1, image2):
    is_equal = compare_images(image1, image2)
    return is_equal


def compare_pixels_from_imagepath(image_path1, image_path2):
    image1 = Image.open(image_path1)
    image2 = Image.open(image_path2)
    is_equal = compare_images(image1, image2)
    return is_equal


if __name__ == "__main__":
    code1 = """def draw(t):
    t.pencolor('red')
    t.forward(100)
    t.left(90)
    t.forward(100)
    t.left(90)
    t.forward(100)
    t.left(90)
    t.forward(100)
    """
    code2 = """def draw(t):
    def draw_square(t):
        for _ in range(4):
            t.forward(100)
            t.left(90)
    draw_square(t)
    """
    is_equal_12 = compare_pixels_from_code(code1, code2)
    is_equal_11 = compare_pixels_from_code(code1, code1)
    is_equal_22 = compare_pixels_from_code(code2, code2)
    print(is_equal_12, is_equal_11, is_equal_22)