import tkinter


def rgb_to_hex(rgb):
    return "#{:02x}{:02x}{:02x}".format(*rgb)


def hex_to_rgb(hex_color):
    hex_color = hex_color.lstrip('#')
    return tuple(int(hex_color[i:i + 2], 16) for i in (0, 2, 4))


def get_tkinter_color_map():
    root = tkinter.Tk()
    root.withdraw()  # Hide the main window

    color_map = {}
    # List of common color names supported by Tkinter
    color_names = [
        "red", "green", "blue", "yellow", "cyan", "magenta", "black", "white",
        "gray", "darkred", "darkgreen", "darkblue", "lightblue", "orange", "pink",
        "purple", "brown", "violet", "indigo", "gold", "silver", "maroon", "lime",
        "navy", "teal", "olive", "salmon", "khaki", "turquoise", "chocolate"
    ]

    for color in color_names:
        try:
            rgb_tuple = root.winfo_rgb(color)
            # Convert to 0-255 range
            rgb_tuple = tuple([int(val / 256) for val in rgb_tuple])
            hex_color = rgb_to_hex(rgb_tuple)
            color_map[color] = {'rgb': rgb_tuple, 'hex': hex_color}
        except tkinter.TclError:
            # If color name is not found, skip it
            continue

    root.destroy()
    return color_map


def color2rgb(color):
    """
    Convert color to rgb format.
    Color can be in the form of:
    - hex color string: '#RRGGBB'
    - color name string: 'red', 'green', etc.
    - rgb tuple: (R, G, B)
    """
    if isinstance(color, str):
        if color[0] == '#':
            # hex color --> rgb
            color = hex_to_rgb(color)
        elif 'rgb' in color:
            # rgb color str --> tuple
            color = tuple(map(int, color.split('(')[1].split(')')[0].split(',')))
        else:
            # color name --> rgb
            color_map = get_tkinter_color_map()
            color = color_map[color]['rgb']
    elif isinstance(color, tuple):
        color = color
    return color
