#!/bin/bash

export PYTHONPATH="./:$PYTHONPATH"
export PYTHONPATH="src/:$PYTHONPATH"


# The following is used to run the turtle graphics in a headless server.
# See: https://stackoverflow.com/a/68121226
# Start Xvfb (X virtual framebuffer) in the background
Xvfb :1 -screen 0 1600x1200x16 &

# Export the DISPLAY environment variable to use the virtual display
export DISPLAY=:1.0

python src/turtlegfx_datagen/codegen/postprocess.py \
  --input_path "src/turtlegfx_datagen/codegen/results/responses/codeedit_inferred_spec__Llama-3.1-70B-Instruct__20241012.json" \
  --output_path "src/turtlegfx_datagen/codegen/results/postprocess/codeedit_inferred_spec__Llama-3.1-70B-Instruct__20241012_test.json" \
  --output_type "success" \
  --save_img
