from src.turtlegfx_datagen.prompts.build_prompts import build_prompts_from_json
import os
import argparse
import uuid


def apply_prompt_template(item, prompt_template):
    """
    Apply the prompt template to the item with the given specs.

    Args:
        item (dict): A dictionary from the input JSON file.
        prompt_template (str): The template string with placeholders.
        specs (list): List of specifications to include in the prompt.

    Returns:
        prompt (str): The generated prompt.
    """
    prompt = prompt_template
    return prompt


def custom_function(item, prompt_template, input_file):
    """
    Custom function to build prompts for a specific scenario.

    Args:
        item (dict): A dictionary from the input JSON file.
        prompt_template (str): The template string with placeholders.
        input_file (str): Path to the input file (for src_file in output).

    Returns:
        results (list): List of dictionaries with keys: 'id', 'messages', 'src_file', 'params'
    """
    id_from_input = item.get('id', '')

    prompt = apply_prompt_template(item, prompt_template)

    message = [
        {
            "role"   : "system",
            "content": "You are a helpful assistant."
        },

        {
            "role"   : "user",
            # "content": prompt
            "content": [  # for qwen2vl
                {
                    "type" : "image",
                    "image": item.get('task_image', ''),
                    # "min_pixels": 224 * 224,
                    # "max_pixels": 1280 * 28 * 28,
                },
                {"type": "text", "text": prompt},
            ],
        }
    ]

    unique_id = f"{id_from_input}--bldpromeva-{uuid.uuid4()}"
    result = {
        "id"      : unique_id,
        "message" : message,
        "src_file": input_file,
        "params"  : {
            "data": item
        }
    }
    return [result]


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Generate prompts from input JSON and template")

    parser.add_argument('--input_file', type=str, required=True, help='Path to input JSON file')
    parser.add_argument('--output_file', type=str, required=True, help='Path to output JSON file')
    parser.add_argument('--prompt_template', type=str, required=True, help='Prompt template string or file path')
    parser.add_argument('--max_num_items', type=int, default=150000, help='Maximum number of items per part')
    args = parser.parse_args()

    # Load the template (from a file or string)
    if os.path.isfile(args.prompt_template):
        with open(args.prompt_template, 'r') as f:
            prompt_template = f.read()
    else:
        prompt_template = args.prompt_template

    build_prompts_from_json(
        input_file=args.input_file,
        output_file=args.output_file,
        prompt_template=prompt_template,
        custom_function=custom_function,
        max_num_items=args.max_num_items,
    )
