
## Continual Learning Without Knowing Task identities : Rethinking Occam's Razor 
PyTorch implementation of our paper : Continual Learning Without Knowing Task identities : Rethinking Occam's Razor identities


#### Prerequisites:
- Python 3.6
- PyTorch 1.6
- CPU or GPU

### Structure of the project
The following structure is expected in the main directory:
```
./configs        : Settings for each experiment
./data           : Data will be automatically downloaded here
./results        : Results are saved in here , this folder will be automatically created
./models         : Different model architectures
./layers         : Bayesian Layers (code borrowed from https://github.com/kumar-shridhar/PyTorch-BayesianCNN)
./tasks          : Generate different continual learning scenarios
./training       : Contains all scripts realted to training, memory management during training and evaluation
```

- To run all the experiments use `/main.py --config <name> --transfer <approach> --sim <simulations>` where `name` is the name of the config file corresponding to the experiment [ `config-split-mnist`,`config-permuted-mnist`, `config-rotation-mnist`, `config-split-cifar`,`config-mnist-svhn`].
where `approach` is [`True`,`False`] for our transfer approach and non-transfer approach respectively and <simulations> is the number of runs to average the results.

###  Reproducing main experiments of our paper (for 1 simulation) :


##### Split-MNIST

```shell
python3 main.py --config config-split-mnist --transfer False --sim 1
python3 main.py --config config-split-mnist --transfer True --sim 1
````

##### Rotation-MNIST

```shell
python3 main.py --config config-rotation-mnist --transfer False  --sim 1
python3 main.py --config config-rotation-mnist --transfer True --sim 1 

````
##### Permuted-MNIST

```shell
python3 main.py --config config-permuted-mnist --transfer False --sim 1
python3 main.py --config config-permuted-mnist --transfer True --sim 1

````

##### Split-CIFAR10

```shell
python3 main.py --config config-split-cifar --transfer False --sim 1
python3 main.py --config config-split-cifar --transfer True --sim 1
````
##### MNIST-SVHN

```shell
python3 main.py --config config-mnist-svhn --transfer False --sim 1
python3 main.py --config config-mnist-svhn --transfer True --sim 1
````


### Experiment parameters:
In the config files, located in the configs folder,  one can specify: 


##### Parameters related to Data
- Task description (i.e tasks_description) is a list containing the description of each task (More details in Section : Customize continual learning tasks)
- Input channel (i.e. inputs)
- Number of classes (i.e outputs)
- Dimensions of the input (i.e. dim)


##### Parameters related to training
- number of epochs (i.e. n_epochs)
- learning rate (i.e. lr)
- batch size (i.e batch_size)  
- network architecture (i.e net_type [`1fc`,`2fc`,`lenet`,`alexnet`] ), with corresponding number of neurons if fc network (i.e hidden)
- activation function (i.e activation_type  [`relu`,`softplus`] )
- maximum number of models in the buffer (i.e capacity)

##### Parameters related to Bayesian framework
- Mean of the prior (i.e prior_mu)
- Std of the (i.e prior_sigma)
- Mean and std for the intial mean of the posterior (i.e posterior_mu_initial)
- Mean and std for the intial variance of the posterior (i.e 'posterior_rho_initial')
- Boolean to specify whether or not to transfer of the posterior between task (i.e transfer_posterior {True, False})



##### Other Parameters
- Device (i.e device [`cpu`,`cuda`])
- Path to folder to store results of this expriment (i.e folder)
- Path to file where log of the experiments are printed (i.e results_file) 


##### Customized continual learning tasks
- Each task is described as a tuple with 5 elements:
  - <dataset_name> [`MNIST`,`CIFAR10`,`SVHN`]
  - <transformation_name> [`rotate`,`permutation`] or `None` 
  - < angle> : Angle of rotation if transformation is `rotate` otherwise `None` 
  - <permutation_seed> : Integer if transformation is `permutation` otherwise `None`
  - <subset_of_class> : Tuple to select the range of labels to included in a tasks (example: (0-5), will select only samples with label from 0 to 4 included )

##### Example for Split-MNIST: 
```python
tasks_description = [('MNIST', None, None, None,(0,2)),('MNIST', None, None, None,(2,4)),
                     ('MNIST', None, None, None,(4,6)),('MNIST', None, None, None,(6,8)),('MNIST', None, None, None,(8,10))]

```
  
##### Example for Rotation MNIST: 
```python

tasks_description = [('MNIST', 'rotate', 0, None,None),('MNIST', 'rotate', 30, None,None),('MNIST', 'rotate', 60, None,None),('MNIST', 'rotate', 90, None,None)]

```
##### Example for Permuted-MNIST: 
```python

tasks_description = [('MNIST', 'permutation', None, 0,None),('MNIST', 'permutation', None, 1,None),('MNIST', 'permutation', None, 2,None),('MNIST', 'permutation', None, 3,None),
                     ('MNIST', 'permutation', None, 4,None),('MNIST', 'permutation', None, 5,None),('MNIST', 'permutation', None, 6,None),('MNIST', 'permutation', None, 7,None),
                     ('MNIST', 'permutation', None, 8,None),('MNIST', 'permutation', None, 9,None)]


```