############### Configuration for Permuted MNIST ###############

# Data parameters

datadir = "./data/mnist"


tasks_description = [('MNIST', 'permutation', None, 0,None),('MNIST', 'permutation', None, 1,None),('MNIST', 'permutation', None, 2,None),('MNIST', 'permutation', None, 3,None),
                     ('MNIST', 'permutation', None, 4,None),('MNIST', 'permutation', None, 5,None),('MNIST', 'permutation', None, 6,None),('MNIST', 'permutation', None, 7,None),
                     ('MNIST', 'permutation', None, 8,None),('MNIST', 'permutation', None, 9,None)]

inputs = 1
outputs=10
dim = 28

# Training parameters


n_epochs = 10
lr = 0.001
batch_size_train = 64
batch_size_test = 64
net_type = '1fc'
neurons = 64
capacity= 10
transfer_posterior = True

# Bayesian paramters
layer_type = 'lrt'  # 'bbb' or 'lrt'
activation_type = 'softplus'  # 'softplus' or 'relu'
priors={
    'prior_mu': 0,
    'prior_sigma': 1,
    'posterior_mu_initial': (0, 0.1),  # (mean, std) normal_
    'posterior_rho_initial': (-5, 0.1),  # (mean, std) normal_
}
beta_type = 0.1  # 'Blundell', 'Standard', etc. Use float for const value

# Other parameters

import torch
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
folder = 'results/results-permutated-mnist'
results_file = 'results.txt'
