############### Configuration for rotation MNIST ###############

# parameters related to data
datadir = "./data/mnist"

tasks_description = [('MNIST', 'rotate', 0, None,None),('MNIST', 'rotate', 30, None,None),('MNIST', 'rotate', 60, None,None),('MNIST', 'rotate', 90, None,None)]

inputs = 1
dim = 28
outputs=10


# Training parameters
n_epochs = 10
lr = 0.001
batch_size_train = 64
batch_size_test = 64
capacity= 4
net_type = '1fc'
neurons = 64

# parameters for Bayesian framework
layer_type = 'lrt'  # 'bbb' or 'lrt'
activation_type = 'softplus'  # 'softplus' or 'relu'
priors={
    'prior_mu': 0,
    'prior_sigma': 1,
    'posterior_mu_initial': (0, 0.1),  # (mean, std) normal_
    'posterior_rho_initial': (-5, 0.1),  # (mean, std) normal_
}

transfer_posterior = True
beta_type = 0.1  # 'Blundell', 'Standard', etc. Use float for const value

# other parameters

import torch
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
folder = 'results/results-rotation-mnist'
results_file = 'results.txt'