############### Configuration for Split CIFAR ###############


# Data parameters
datadir = "./data/cifar10"

tasks_description = [('CIFAR10', None, None, None,(0,2)),('CIFAR10',None, None, None,(2,4)),
                     ('CIFAR10', None, None, None,(4,6)),('CIFAR10', None, None, None,(6,8)),('CIFAR10', None, None, None,(8,10))]

dim = 32
inputs = 3
outputs=10


# Training
n_epochs = 10
lr = 0.0002
batch_size_train = 64
batch_size_test = 64
activation_type = 'softplus'  # 'softplus' or 'relu'
net_type = '1fc'
neurons = 200

capacity= 5



# Parameters related to Bayesian framework

layer_type = 'lrt'  # 'bbb' or 'lrt'

priors={
    'prior_mu': 0,
    'prior_sigma': 0.1,
    'posterior_mu_initial': (0, 0.1),  # (mean, std) normal_
    'posterior_rho_initial': (-5, 0.1),  # (mean, std) normal_
}

beta_type = 0.1  # 'Blundell', 'Standard', etc. Use float for const value

transfer_posterior = True

import torch
device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
folder = 'results/results-split-cifar10'
results_file = 'results.txt'
