#!/usr/bin/env python3
from uimnet.algorithms.base import Algorithm
from uimnet.algorithms.distillation import RND, OC, DetachedRND, DetachedOC
from uimnet.algorithms.erm import ERM
from uimnet.algorithms.mcdropout import MCDropout
from uimnet.algorithms.mimo import MIMO
from uimnet.algorithms.mixup import Mixup
from uimnet.algorithms.rbf import RBF
from uimnet.algorithms.soft_labeler import SoftLabeler
from uimnet.algorithms.due import DUE
from uimnet.algorithms.deep_ae import DeepAE

__algorithms__ = [
                  # RND, OC,
                  # ERM, MCDropout, MIMO, Mixup,
                  # RBF,
                  SoftLabeler,
                  DUE,
                  # DeepAE,
                  DetachedRND, DetachedOC]
__ALGORITHMS__ = {el.__name__: el for el in __algorithms__}
