import os
import choix
# from config import args
import pandas as pd

def calcu_BT_score_from_mtx(mtx):
    # create comparisons data
    comparisons = []
    for i, player_i in enumerate(mtx.index):
        for j, player_j in enumerate(mtx.columns):
            if i != j and mtx.iloc[i, j] > 0:
                wins_i = mtx.iloc[i, j]
                losses_i = mtx.iloc[j, i]
                comparisons.extend([(i, j)] * int(wins_i))
                comparisons.extend([(j, i)] * int(losses_i))

    init_scores = [1.0] * len(mtx.index)

    # estimating Bradley-Terry scores
    '''
    param for choix.ilsr_pairwise

    n_items : int
        Number of distinct items.
    data : list of lists
        Pairwise-comparison data.
    alpha : float, optional
        Regularization parameter.
    initial_params : array_like, optional
        Parameters used to initialize the iterative procedure.
    max_iter : int, optional
        Maximum number of iterations allowed.
    tol : float, optional
        Maximum L1-norm of the difference between successive iterates to declare convergence.
    '''
    bt_scores = choix.ilsr_pairwise(n_items = len(mtx.index), data = comparisons, alpha = 0.01, initial_params = init_scores)

    scores = pd.Series(bt_scores, index=mtx.index)

    # print(scores)
    return scores


dataset_name = 'personal_preference_eval_preference_data'
model_names = ['Meta-Llama-3.1-8B-Instruct', 'Mistral-7B-Instruct-v0.2', 'Llama-2-7b-chat-hf', 'Qwen2-7B-Instruct']
dimens = ['concise', 'creative', 'uplifting', 'verbose']

for model_name in model_names:
    print(f'################# {model_name} is start ################# \n')
    for dimen in dimens:

        mtx = pd.read_csv(os.path.join(os.getcwd(), f"results/gpt_eval/{dimen}/{model_name}/{dataset_name}/gpt_winner_mtx.csv"))
        mtx = mtx.set_index('Unnamed: 0')

        print(f'################# {model_name} {dimen} is start ################# \n')
        print(calcu_BT_score_from_mtx(mtx))
        print()
        print(f'################# {model_name} {dimen} is done ################# \n')

        
    print(f'################# {model_name} is done ################# \n')


