import argparse
import torch
import os

parser = argparse.ArgumentParser(description='Amulet')
parser.add_argument('--method', type=str, default='amulet',
                    help='name of the method')
parser.add_argument('--model_name', type=str, default='LLMs/llama-2-7b-chat-hf',
                    help='path of the using LLM')
parser.add_argument('--eval_data', type=str, default='UltraFeedback_truthful_qa.json',
                    help='path of the eval dataset in the datasets folder')
parser.add_argument('--pref_name', type=str, default='verbosity',
                    help='specific user needs by prompt')
parser.add_argument('--max_new_tokens', type=int, default=128,
                    help='the maximum number of tokens to generate. In other words, the size of the output sequence, not including the tokens in the prompt')
parser.add_argument('--temperature', type=float, default=0.7,
                    help='generation randomness')   
parser.add_argument('--num_processes', type=int, default=1,
                    help='the number of the prallel processes')   
parser.add_argument('--seed', type=int, default=42,
                    help='randomnesss control')
parser.add_argument('--top_p', type=float, default=0.95,
                    help='confidence interval')   
parser.add_argument('--top_k', type=int, default=1,
                    help='generation beam num')     
parser.add_argument('--eta', type=float, default=10,
                    help='learning ratio')   
parser.add_argument('--alpha', type=float, default=2.0,
                    help='reward ratio for coordinating preference direction') 
parser.add_argument('--player_lambda', type=float, default=2.0,
                    help='Lagrange multiplier for each player')  
parser.add_argument('--iteration_num', type=int, default=100,
                    help='iteration number for FTRL')  
parser.add_argument('--batch_size', type=int, default=1,
                    help='batch size')    
parser.add_argument('--reinforce_ratio', type=float, default=2.0,
                    help='difference reinforcement degree')   
parser.add_argument('--device', type=str, default='cuda:0',
                    help='use which gpu device')
parser.add_argument('--cuda', default=False, action='store_true')
# parser.add_argument('--cuda', default=True, action='store_false')  


args = parser.parse_args()

args.device = torch.device(args.device if torch.cuda.is_available() and args.cuda else "cpu")

print("=================Arguments==================")
for k, v in args.__dict__.items():
    print('{}: {}'.format(k, v))
print("========================================")

