# BBQ Project - Bayesian ELO Rating System wiht Rater Quality

## Installation

### Prerequisites
```bash
# Ubuntu/Debian
sudo apt install cmake build-essential git

# CentOS/RHEL/Fedora
sudo yum install cmake gcc-c++ make git
# OR: sudo dnf install cmake gcc-c++ make git

# macOS
brew install cmake git
```

### Setup
```bash
# 1. Clone repository
git clone <repository-url> && cd bbq

# 2. Create environment (choose one)
micromamba env create -f env.yaml                    # Fastest
# OR: conda env create -f env.yaml                   # Standard

# 3. Compile C++ binary
cd src/google_elo && ./compile.sh && cd ../..

# 4. Configure paths in config.py
# Edit config.py with your system paths

# 5. Create directories
mkdir -p logs results /tmp/bbq_temp
```

## Project Structure

```
bbq/
├── config.py                     # Configuration file with all paths
├── env.yaml                      # Conda environment specification
├── create_results_table.py       # Results table creation
├── src/                          # Source code
│   ├── bootstrap.py              # Bootstrap analysis
│   ├── google_elo_wrapper.py     # Google ELO wrapper
│   ├── google_elo_processor.py   # ELO processing utilities
│   ├── models.py                 # Model definitions
│   └── google_elo/               # Google ELO C++ implementation
├── projects/                     # Project datasets
│   ├── clic2024/                 # CLIC 2024 data
│   ├── conha/                    # CONHA data
│   ├── hific/                    # HiFiC data
│   ├── mtbench/                  # MT-Bench data
│   ├── prolific/                 # Prolific data
│   └── WD/                       # WD data
├── results/                      # All bootstrap results (organized by project/dataset/model)
└── logs/                         # Log files
```

## Troubleshooting

**Installation Issues:**
- **CMake not found**: `sudo apt install cmake build-essential` (Ubuntu) or `brew install cmake` (macOS)
- **Compilation fails**: Check you're in `src/google_elo/` directory, verify `gcc --version`
- **Environment creation fails**: Try manual setup or check conda/micromamba installation
- **Permission denied**: `chmod +x src/google_elo/compile.sh`

**Runtime Issues:**
- **Python import errors**: Activate environment with `micromamba activate elo_rater_model`
- **Python execution errors**: Check environment activation and dependencies
- **Config errors**: Verify paths in `config.py` exist and create directories
- **Data format errors**: Check data structure with `head projects/{dataset}/data/*.csv`

**If compilation fails:**
```bash
cd src/google_elo
mkdir -p build && cd build
cmake .. && make
```

## Usage

Run individual bootstrap with custom parameters:
```bash
micromamba run -n elo_rater_model python src/bootstrap.py \
  --project_name WD \
  --csv_name answers.csv \
  --bootstrap_n 10 \
  --model google_elo
```


## Create Results Table

After running bootstrap analysis, create formatted results tables:

```bash
# Create LaTeX table from results
micromamba run -n elo_rater_model python create_results_table.py results/

# Output saved to output.txt
cat output.txt
```


