import argparse

def arg_parse():
    parser = argparse.ArgumentParser(description='GcnInformax Arguments.')
    parser.add_argument('--DS', dest='DS', help='Dataset', default='IMDB-BINARY', type=str)
    parser.add_argument('--nCluster', type=int, default=-1, help='Number of clusters')
    parser.add_argument('--embType', type=str, default='motifs', help='Embedding type: gcn or motifs')
    parser.add_argument('--node_attr', type=str, default='ones', help='Node attributes: ones or random (for gcn case)')
    parser.add_argument('--J', type=int, default=10, help='Number of graphs to estimate graphon')
    parser.add_argument('--estGraphon', type=str, default='SIGL', help='alg to estimate graphon for each cluster')
    parser.add_argument('--seed', type=int, default=0, help='Random seed')
    return parser.parse_args()

