import argparse

def arg_parse():
    parser = argparse.ArgumentParser(description='GcnInformax Arguments.')
    parser.add_argument('--DS', dest='DS', help='Dataset')
    parser.add_argument('--local', dest='local', action='store_const', 
            const=True, default=False)
    parser.add_argument('--glob', dest='glob', action='store_const', 
            const=True, default=False)
    parser.add_argument('--prior', dest='prior', action='store_const', 
            const=True, default=False)

    parser.add_argument('--lr', dest='lr', type=float,
            help='Learning rate.', default=0.01)
    parser.add_argument('--num-gc-layers', dest='num_gc_layers', type=int, default=3,
            help='Number of graph convolution layers before each pooling')
    parser.add_argument('--hidden-dim', dest='hidden_dim', type=int, default=32,
            help='')

    parser.add_argument('--aug', type=str, default='pedges_gr')
    parser.add_argument('--seed', type=int, default=None)
    parser.add_argument('--Rpos', type=float, default=0.1)
    parser.add_argument('--isPlot', type=int, default=0)
    parser.add_argument('--J', type=int, default=None)
    parser.add_argument('--nCluster', type=int, default=None)
    parser.add_argument('--log-interval', type=int, default=5)
    
    return parser.parse_args()

