#!/usr/bin/env bash
# set -euo pipefail
# set -x

mkdir -p logs_new/{MUTAG,IMDB-BINARY,PROTEINS,DD,NCI1,COLLAB,REDDIT-BINARY,REDDIT-MULTI-5K}
mkdir -p data/MGCL/{MUTAG,IMDB-BINARY,PROTEINS,DD,NCI1,COLLAB,REDDIT-BINARY,REDDIT-MULTI-5K}

# MUTAG
python -u get_emb.py --DS MUTAG > logs_new/MUTAG/getemb.log
python -u sim_gr.py --DS MUTAG --nCluster 10 --seed 0 > logs_new/MUTAG/sigl.log
for seed in 0 1 2 3 4; do
  python -u MGCL.py --DS MUTAG --seed "$seed" > "logs_new/MUTAG/MGCL_seed${seed}.log"
done
echo "MUTAG done"

# IMDB-BINARY
# python -u get_emb.py --DS IMDB-BINARY > logs_new/IMDB-BINARY/getemb.log
# python -u sim_gr.py --DS IMDB-BINARY --nCluster 10 --seed 2 > logs_new/IMDB-BINARY/sigl.log
# for seed in 0 1 2 3 4; do
#   python -u gsimclr_mine_fast.py --DS IMDB-BINARY --seed "$seed" > "logs_new/IMDB-BINARY/MGCL_seed${seed}.log"
# done
# echo "IMDB-BINARY done"

# # DD
# python -u get_emb.py --DS DD > logs_new/DD/getemb.log
# python -u sim_gr.py --DS DD --nCluster 10 --seed 3 > logs_new/DD/sigl.log
# for seed in 0 1 2 3 4; do
#   python -u gsimclr_mine_fast.py --DS DD --seed "$seed" > "logs_new/DD/MGCL_seed${seed}.log"
# done
# echo "DD done"

# # # COLLAB
# # python -u get_emb.py --DS COLLAB > logs_new/COLLAB/getemb.log
# python -u sim_gr.py --DS COLLAB --nCluster 20 --seed 4 > logs_new/COLLAB/sigl.log
# for seed in 0 1 2 3 4; do
#   python -u gsimclr_mine_fast.py --DS COLLAB --seed "$seed" > "logs_new/COLLAB/MGCL_seed${seed}.log"
# done
# echo "COLLAB done"

# # # NCI1
# # python -u get_emb.py --DS NCI1 > logs_new/NCI1/getemb.log
# python -u sim_gr.py --DS NCI1 --nCluster 20 --seed 0 > logs_new/NCI1/sigl.log
# for seed in 0 1 2 3 4; do
#   python -u gsimclr_mine_fast.py --DS NCI1 --lr 0.001 --seed "$seed" > "logs_new/NCI1/MGCL_seed${seed}.log"
# done
# echo "NCI1 done"

# # # REDDIT-BINARY
# # python -u get_emb.py --DS REDDIT-BINARY > logs_new/REDDIT-BINARY/getemb.log
# python -u sim_gr.py --DS REDDIT-BINARY --nCluster 10 --seed 0 > logs_new/REDDIT-BINARY/sigl.log
# for seed in 0 1 2 3 4; do
#   python -u gsimclr_mine_fast.py --DS REDDIT-BINARY --seed "$seed" > "logs_new/REDDIT-BINARY/MGCL_seed${seed}.log"
# done
# echo "REDDIT-BINARY done"


# # PROTEINS
# python -u get_emb.py --DS PROTEINS > logs_new/PROTEINS/getemb.log
# python -u sim_gr.py --DS PROTEINS --nCluster 10 --seed 0 > logs_new/PROTEINS/sigl.log
# for seed in 0 1 2 3 4; do
#   python -u gsimclr_mine_fast.py --DS PROTEINS --seed "$seed" > "logs_new/PROTEINS/MGCL_seed${seed}.log"
# done
# echo "PROTEINS done"



# # # REDDIT-MULTI-5K
# # python -u get_emb.py --DS REDDIT-MULTI-5K > logs_new/REDDIT-MULTI-5K/getemb.log
# python -u sim_gr.py --DS REDDIT-MULTI-5K --nCluster 20 --seed 0 > logs_new/REDDIT-MULTI-5K/sigl.log
# for seed in 0 1 2 3 4; do
#   python -u gsimclr_mine_fast.py --DS REDDIT-MULTI-5K --lr 0.001 --seed "$seed" > "logs_new/REDDIT-MULTI-5K/MGCL_seed${seed}.log"
# done
# echo "REDDIT-MULTI-5K done"
