#include <vector>
#include <string>
#include "drot.hpp"
#include "reader.hpp"

int main(int argc, char *argv[]) {
    const std::vector<int> dims{100, 200, 500, 1000, 2000, 5000, 10000, 20000};
    const int maxiters = 100;
    const int ntests = 10;
    const float eps = 1E-14;
    std::string filename, filename_;

    for (const auto &nrows: dims) {
        auto ncols = nrows;
        std::vector<float> p(nrows, 1/(float) nrows);
        std::vector<float> q(ncols, 1/(float) ncols);
        const float stepsize = 2/(float) (nrows + ncols);

        for (int idx=0; idx<ntests; idx++) {
            filename = "examples/data/cmatrix_" + std::to_string(nrows) + "_test_" +
                std::to_string(idx);
            auto C = utility::load<float>(filename, nrows, ncols);
            filename_ = "examples/output/drot_runtime_prof" + std::to_string(nrows)
                + "_test_" + std::to_string(idx) + ".csv";
            drot<float>(&C[0], &p[0], &q[0], nrows, ncols, stepsize,
                maxiters, eps, false, true, filename_);
        }
    }
    return 0;
}
