# Model Similarity Analysis using CKA

This repository contains Python scripts to analyze the similarity between different transformer-based language models using Centered Kernel Alignment (CKA) on their attention weights. The primary focus is on comparing the Query (Q) and Key (K) projection matrices within the attention mechanism.

The methodology involves:
1.  Loading model weights from checkpoints.
2.  Extracting attention (Q, K, V, O) weights for each layer.
3.  When comparing models with different hidden dimensions, aligning the feature spaces using their shared word embeddings.
4.  Calculating the CKA similarity score for each corresponding layer.
5.  Visualizing the layer-wise similarity scores to identify patterns.

## Project Structure

```
.
├── run_analysis.py         # Main script to run experiments
├── similarity_metrics.py   # Core functions for CKA, weight loading, and alignment
├── configs.py              # Experiment configurations (model paths, comparison pairs)
├── requirements.txt        # Python dependencies
└── figures/                # Output directory for generated plots
```

## Setup

1.  **Clone the repository:**
    ```bash
    git clone <repository_url>
    cd <repository_name>
    ```

2.  **Install dependencies:**
    It is recommended to use a virtual environment.
    ```bash
    pip install -r requirements.txt
    ```

3.  **Download Model Checkpoints:**
    - Download the model checkpoints you wish to analyze.
    - Place them in a single directory (e.g., `checkpoints/`).
    - Update the `CHECKPOINT_BASE_DIR` variable in `configs.py` to point to this directory.

    For example, your directory structure should look like this:
    ```
    .
    ├── analysis_code/
    │   ├── run_analysis.py
    │   └── ...
    └── checkpoints/
        ├── Llama-2-7B-fp16/
        │   ├── model-00001-of-00002.safetensors
        │   └── ...
        └── vicuna-7b-v1.5/
            ├── pytorch_model-00001-of-00002.bin
            └── ...
    ```


## Usage

The main script `run_analysis.py` is used to execute the similarity analysis. You need to specify an experiment configuration defined in `configs.py`.

```bash
python run_analysis.py --config <config_name>
```

-   `--config`: The name of the experiment configuration to run (e.g., `sft_pairs`, `moe_pairs`). See `configs.py` for all available options.
-   `--device`: (Optional) The device to use for computation (`auto`, `cpu`, `cuda`). Defaults to `auto`, which will use a GPU if available.

**Example:**
To run the comparison for supervised fine-tuned models:
```bash
python run_analysis.py --config sft_pairs
```

The script will output the average similarity scores to the console and save a layer-wise similarity plot in the `figures/qk_cka/` directory.
