#!/bin/bash
set -x
export NCCL_TIMEOUT=36000
# Warning: Export VLLM_ATTENTION_BACKEND on every machine before starting Ray cluster.
# vLLM without XFORMERS will results in CUDA errors.
# export VLLM_ATTENTION_BACKEND=XFORMERS
INNER=1.0
INTER=1.0
FORMAT_ERROR=-5.0
MARGIN=0.2
INTER_ADV_SPECIAL_TOKEN_ONLY=False
DRGRPO=True
# Parse command line arguments
while [[ $# -gt 0 ]]; do
    case $1 in
        --model)
            MODEL_PATH="$2"
            shift 2
            ;;
        *)
            break
            ;;
    esac
done


# 解析剩余的位置参数
if [[ $# -ge 1 ]]; then
    INNER="$1"
    shift
fi

if [[ $# -ge 1 ]]; then
    INTER="$1"
    shift
fi

if [[ $# -ge 1 ]]; then
    FORMAT_ERROR="$1"
    shift
fi


if [[ $# -ge 1 ]]; then
    MARGIN="$1"
    shift
fi

if [[ $# -ge 1 ]]; then
    INTER_ADV_SPECIAL_TOKEN_ONLY="$1"
    shift
fi

if [[ $# -ge 1 ]]; then
    DRGRPO="$1"
    shift
fi



# Set default model path if not provided
if [ -z "$MODEL_PATH" ]; then
    MODEL_PATH="cpkt"
fi


# Train over 4 nodes, 8 A100-80GB GPUs per node.
python3 -m verl.trainer.main_ppo \
    algorithm.adv_estimator=grpo \
    data.train_files="deepscaler40k_general50k_data.parquet" \
    data.val_files=math64.parquet \
    data.val_files2=wildchat64.parquet \
    data.train_batch_size=256 \
    data.val_batch_size=256 \
    data.max_prompt_length=1024 \
    data.max_response_length=24576 \
    actor_rollout_ref.model.path=$MODEL_PATH \
    actor_rollout_ref.actor.optim.lr=1e-6 \
    actor_rollout_ref.model.use_remove_padding=True \
    actor_rollout_ref.actor.ppo_mini_batch_size=128 \
    actor_rollout_ref.actor.ppo_epochs=1 \
    actor_rollout_ref.actor.use_dynamic_bsz=True \
    actor_rollout_ref.actor.ppo_max_token_len_per_gpu=32768 \
    actor_rollout_ref.actor.use_kl_loss=True \
    actor_rollout_ref.actor.kl_loss_coef=0.001 \
    actor_rollout_ref.actor.kl_loss_type=mse \
    actor_rollout_ref.actor.ulysses_sequence_parallel_size=1 \
    actor_rollout_ref.model.enable_gradient_checkpointing=True \
    actor_rollout_ref.actor.fsdp_config.param_offload=False \
    actor_rollout_ref.actor.fsdp_config.optimizer_offload=False \
    actor_rollout_ref.rollout.tensor_model_parallel_size=1 \
    actor_rollout_ref.rollout.name=vllm \
    actor_rollout_ref.rollout.temperature=0.6 \
    actor_rollout_ref.rollout.gpu_memory_utilization=0.8 \
    actor_rollout_ref.rollout.n=4 \
    actor_rollout_ref.ref.fsdp_config.param_offload=True \
    algorithm.kl_ctrl.kl_coef=0.001 \
    trainer.critic_warmup=0 \
    trainer.logger=['console','wandb'] \
    trainer.project_name='hybrid_reasoning_final' \
    trainer.experiment_name="math-1.5b-24k-grpo-v0.2.0-kl2-formatscore${FORMAT_ERROR}-inner${INNER}-inter${INTER}-margin${MARGIN}-advspcial${INTER_ADV_SPECIAL_TOKEN_ONLY}-DrGRPO${DRGRPO}" \
    +trainer.val_before_train=True \
    trainer.n_gpus_per_node=8 \
    trainer.nnodes=1 \
    trainer.save_freq=20 \
    trainer.test_freq=10 \
    trainer.default_hdfs_dir=null \
    trainer.total_epochs=5 "${@:1}" \
    actor_rollout_ref.rollout.enforce_eager=False \
    actor_rollout_ref.rollout.free_cache_engine=False \
    trainer.default_local_dir="results/hybrid-training-v0.2.0-final/math-1.5b-24k-grpo-v0.2.0-kl2-formatscore${FORMAT_ERROR}-inner${INNER}-inter${INTER}-margin${MARGIN}-advspcial${INTER_ADV_SPECIAL_TOKEN_ONLY}-DrGRPO${DRGRPO}" \
    reward_model.model.path="allenai/Llama-3.1-Tulu-3-8B-RM" \
    trainer.val_generations_to_log_to_wandb=8 \
    algorithm.group_inner_alpha=${INNER} \
    algorithm.group_inter_alpha=${INTER} \
    algorithm.format_error_reward=${FORMAT_ERROR} \
    algorithm.margin=${MARGIN} \
    algorithm.inter_adv_special_token_only=${INTER_ADV_SPECIAL_TOKEN_ONLY} \
    actor_rollout_ref.actor.DrGRPO=${DRGRPO} \
    actor_rollout_ref.actor.entropy_coeff=0.0 \
