<div align="center">
<h2>Self-Supervised Learning of Motion Concepts by Optimizing Counterfactuals</h2>

</div>

This work presents Opt-CWM, an unsupervised model for optical flow prediction. Opt-CWM builds on the Counterfactual World Modeling (CWM) paradigm, achieving state-of-the-art performance on the TAP-Vid benchmark.


## 🔨 Installation
```bash
# in project directory 

conda create -n optcwm python=3.10
conda activate optcwm
pip install -e .
```

## 🔧 Configs
We provide sample YAML files in `configs/` that show the configurations used for training and evaluation. Specific model input parameters are frozen to default (train-time checkpointed) configurations, which can be found in `models/builder.py`. 
This can be modified dynamically through YAML, e.g. 
```yaml 
# configs/eval_configs.yaml
model_args: 
  flow_predictor:
    zoom_iters: 4
    masking_iters: 10
...
```
will pass the configured `zoom_iters` and `masking_iters` to the `FlowPredictor` class. Equivalently, configurations can be set through CLI, e.g.
```bash
python demo.py \
 --yaml=configs/eval_cfg.yaml \
 --model_args.flow_predictor.zoom_iters=4
```

## ✨ Usage
To use the pretrained FlowPredictor, run the following: 
```python
from model import builder

model_args = ... # get model args from YAML or CLI

model = builder.get_flow_predictor(model_args)
model.load_pretrained(highres=True, force=False)
```
This will initialize the flow predictor with the appropriate configs (which can be overwritten as described above) and automatically download the checkpoint to `$CACHE`. 

Similarly, to load the full pretrained Opt-CWM model ($\Psi^{\texttt{flow}}$ in paper), 
```python
from model import builder

model_args = ... # get model args from YAML or CLI

model = builder.get_opt_cwm(model_args)
model.load_pretrained(force=False)
```

### Running the Flow Predictor
To demo the trained model on a sample frame pair, run
```bash 
./scripts/run_demo.sh
```
Refer to `demo.py` for an example of using the pre-trained FlowPredictor on sample images.

## 📀 Data

To use configs and convenience scripts out of the box, we recommend downloading the directory and organizing it in the following way: 
```bash 
|-models 
|-data 
|-datasets
|   ├── tapvid
|   |    ├── tapvid_kinetics_sampled.pkl
|   |    ├── tapvid_davis.pkl
|   ├── kinetics
|   |    ├── kinetics400_training_list.txt
...
```
## 🧪 Evaluation
Ensure that the TAP-Vid dataset is correctly downloaded. The evaluations reported in the paper can be run by
 
```bash
./scripts/run_tapvid_eval.sh [DATASET] [EVALUATION] 

# e.g. ./run_eval.sh davis first
```