zero_prompt_gsm = """
Based on the question below, please strictly follow this format when answering:
1. Start with [Strategy] section explaining the general approach for solving similar problems;
2. End with [Answer] section containing ONLY the value. (1) Do NOT include units such as minutes, feet, etc.; (2) Do NOT include any explanations; (3) If there is no answer, RETURN None as the value.

Example:
[Question]: x + y = 10, y = 4, what is x?
[Strategy]: To solve for x, isolate x by subtracting y from both sides of the equation. x = 10 - y = 10 - 4 = 6.
[Answer]: 6

Now answer this question:
[Question]: {question}
[Strategy]:
[Answer]:
"""

fewshot_prompt_gsm = """
Using the following problem examples:

{context}

Based on the question below, please strictly follow this format when answering:
1. Start with [Strategy] section explaining the general approach for solving similar problems;
2. End with [Answer] section containing ONLY the value. (1) Do NOT include units such as minutes, feet, etc.; (2) Do NOT include any explanations; (3) If there is no answer, RETURN None as the value.

Now answer this question:
[Question]: {question}
[Strategy]:
[Answer]:
"""

zero_prompt_gsm_symbolic = """
Based on the question below, please strictly follow this format when answering:
1. Start with [Strategy] section explaining the general approach for solving similar problems;
2. End with [Answer] section containing ONLY the value. (1) Do NOT include units such as minutes, feet, etc.; (2) If the question asks for a percentage, ONLY provide the number (e.g., answer 20 instead of 20%); (3) Do NOT include any explanations; (4) If there is no answer, RETURN None as the value.

Example:
[Question]: x + y = 10, y = 4, what is x?
[Strategy]: To solve for x, isolate x by subtracting y from both sides of the equation. x = 10 - y = 10 - 4 = 6.
[Answer]: 6

Now answer this question:
[Question]: {question}
[Strategy]:
[Answer]:
"""

fewshot_prompt_gsm_symbolic = """
Using the following problem examples:

{context}

Based on the question below, please strictly follow this format when answering:
1. Start with [Strategy] section explaining the general approach for solving similar problems;
2. End with [Answer] section containing ONLY the value. (1) Do NOT include units such as minutes, feet, etc.; (2) If the question asks for a percentage, ONLY provide the number (e.g., answer 20 instead of 20%); (3) Do NOT include any explanations; (4) If there is no answer, RETURN None as the value.

Now answer this question:
[Question]: {question}
[Strategy]:
[Answer]:
"""

check_correct_prompt = """
Check if {llm_answer} and {ground_truth} are exactly the same numerically.
Compare them as numbers, handling formats like percentages, fractions, and scientific notation.
If they are equal, return True; else return False. ONLY return True or False.
"""

zero_prompt_nasa_history = """
Based on the question below, please strictly follow this format when answering:
1. Start with [Strategy] section explaining the general approach for solving similar problems;
2. End with [Answer] section containing ONLY the single capital letter of the correct option (exactly one of: A, B, C, D). Do NOT include the option text or any explanation.

Example:
[Question]: Which of the following was a direct result of the Treaty of Versailles (1919)?
A. The outbreak of World War II
B. The United States declaring war on Germany and entering World War I
C. The establishment of the Fascist regime in Italy
D. The creation of the League of Nations
[Strategy]: Recall that the treaty ended World War I and included peacekeeping measures. Compare options with the treaty: only the League of Nations was directly established by it.
[Answer]: D

Now answer this question:
[Question]: {question}
[Strategy]:
[Answer]:
"""

fewshot_prompt_nasa_history = """
Using the following problem examples:

{context}

Based on the question below, please strictly follow this format when answering:
1. Start with [Strategy] section explaining the general approach for solving similar problems;
2. End with [Answer] section containing ONLY the single capital letter of the correct option (exactly one of: A, B, C, D). Do NOT include the option text or any explanation.

Now answer this question:
[Question]: {question}
[Strategy]:
[Answer]:
"""

def format_context(relevant_docs, strategy_key_name="strategy", answer_key_name="answer"):
    context = ""
    for i, item in enumerate(relevant_docs):
        question = item.get("question", "")
        strategy = item.get(strategy_key_name, "")
        answer = item.get(answer_key_name, "")

        context += f"{i+1}.[Question]: {question}\n"
        context += f"[Strategy]: {strategy}\n"
        context += f"[Answer]: {answer}\n\n"
    return context

