# Perceiver IO

This directory contains our implementation of Perceiver IO.
The `perceiver.py` file contains our implementation of Perceiver IO,
and `io_processors.py` contains input and output processors
for the experiments we ran.

## Usage

First, install dependencies following these instructions:

1. Create a virtual env: `python3 -m venv ~/.venv/perceiver`
2. Switch to the virtual env: `source ~/.venv/perceiver/bin/activate`
3. Follow instructions for installing JAX on your platform:
   https://github.com/google/jax#installation
4. Install other dependencies: `pip install -f requirements.txt`

After installing dependencies, you can run our example training script.
Our training script assume that you are running from the directory 
containing `perceiver`.

### Training scripts
We provide an example training script to train a Perceiver IO model for
ImageNet classification.
The provided hyperparameters are the settings used to train Perceiver IO
with 2D Fourier position encodings.

To run the script locally and train a miniature Perceiver IO model,
run: `perceiver/train/launch_local.sh`.
The script would need to be adapted to run on a distributed training setup
in order to train a full-scale model with the full batch size.

## Attributions

The file `perceiver/train/autoaugment.py` originates from the `tensorflow/tpu`
repository (https://github.com/tensorflow/tpu/blob/b24729de804fdb751b06467d3dce0637fa652060/models/official/efficientnet/autoaugment.py),
copyright (c) The Tensorflow Authors.