# Source Code: Learning Similarity Metrics for Volumetric Simulations with Multiscale CNNs

This is the source code is for evaluating the proposed <em>VolSiM</em> metric on some volumetric example data sequences. The full source code to train the metric model, the generation scripts to create and collect data, as well as all full data sets will be published upon acceptance.

To install the required python packages (see `requirements.txt`), we recommoned to use Linux as the OS, but the code should work on Windows as well. To set up a conda enviroment (e.g. via [miniconda](https://docs.conda.io/en/latest/miniconda.html)), run the following commands inside the root folder.

```
conda create --name VOLSIM --file requirements.txt
conda activate VOLSIM
```
If you want to make use of GPU computations in PyTorch, you might need to manually re-install PyTorch with:

```
conda install -c pytorch pytorch
```
To check that everything works correctly, the following command runs a simple example script. Check if the resulting distance output matches with the comment inside the script file.

```
python src/distance_example_simple.py
```
The file `src/distance_example_detailed.py` contains a more detailed example, that also computes correlation values between the ground truth from the similarity model and predicted distances. Furthermore, `src/plot_data_vis.py` can be used to create the images in the `results` folder, that visualize the data sequences with ground truth distances determined by the entropy-based similarity model. All scripts contain some adjustable parameters at the top, and can be run like the simple example above, by replacing the file path.

All copyrights belong to the authors of the paper Learning Similarity Metrics for Volumetric Simulations with Multiscale CNNs that is currently under review at the conference ICLR 2022. Please do not distribute this source code.