# Co-Representation Neural Hypergraph Diffusion for Edge-Dependent Node Classification (CoNHD)

CoNHD is a novel and effective hypergraph neural network for solving the ENC problem based on hypergraph diffusion.

This repository provides the implementation of the CoNHD Model along with the instructions for reproducing our experiments. The general training pipeline is based on the implementation of [WHATsNet](https://github.com/young917/EdgeDependentNodeLabel).

## Environment

The code is tested using Python 3.8 and cuda 11.3. Some packages can be installed following `install.sh` to ensure the same version. 

For the version of other packages, check `requirements.txt`.

## Getting Started

### Preprocessing

The datasets can be preprocessed by running the following command, which generates the initial node features by hypergraph random walk: 

```shell
cd script
bash ./preprocess.sh
```

### Training and Evaluation

The following command train the CoNHD model on different ENC dataset and output the evaluation results:  

```shell
cd script/edge_dependent_node_classification
bash ./run_[emailEnron, emailEu, StackOverflowBiology, StackOverflowPhysics, DBLP, AMinerAuthor, cora_outsider, dblp_outsider, citeseer_outsider, pubmed_outsider].sh
```

The following command train the CoNHD model with different depth: 
```shell
cd script/oversmoothing
bash ./run_citeseer_outsider.sh
```

To reproduce the ablation results, run the following command: 

```shell
cd script/ablation_study
bash ./run_[emailEnron, emailEu].sh
```

To reproduce the experiments of fitting diffusion results, run the following command: 

```shell
cd script/fit_diffusion_from_node_feat
bash ./run_senate_[ce, tv, lec].sh
```



