#!/bin/bash
cd ../..
dim=256
seedlist=("0" "10" "100" "500" "10000")
for seed in ${seedlist[@]}
do
    # CoNHD_ADMM (ISAB)
    python train_fit_diffusion_from_node_feat.py --dataset_name senate_committees_repeat_100 --optim ADMM --hedge_reg tv --node_reg tv --feat_dim 1 --nstep 2 --embedder CoNHD_ADMM --att_type_v pure --att_type_e pure --num_att_layer 2 --num_layers 2 --scorer im --scorer_num_layers 1 --bs 315 --lr 0.002 --node_sampling -1 --hedge_sampling -1 --dropout 0.7 --optimizer "adam" --gamma 0.9 --dim_hidden ${dim} --epochs 100 --valid_epoch 5 --evaltype test --save_best_epoch --seed ${seed} --co_rep_dim ${dim} --PE_Block ISAB --use_gpu 
    # CoNHD_GD (ISAB)
    python train_fit_diffusion_from_node_feat.py --dataset_name senate_committees_repeat_100 --optim ADMM --hedge_reg tv --node_reg tv --feat_dim 1 --nstep 2 --embedder CoNHD_GD --att_type_v pure --att_type_e pure --num_att_layer 2 --num_layers 2 --scorer im --scorer_num_layers 1 --bs 315 --lr 0.002 --node_sampling -1 --hedge_sampling -1 --dropout 0.7 --optimizer "adam" --gamma 0.9 --dim_hidden ${dim} --epochs 100 --valid_epoch 5 --evaltype test --save_best_epoch --seed ${seed} --co_rep_dim ${dim} --PE_Block ISAB --use_gpu 
done

