import os
import os.path as osp
import glob
import subprocess
import argparse

import sys

sys.path.append("./")
from data_generator.init_gaussian import InitParams


def main(args, init_parser):
    dataset_path = args.data
    device = args.device

    case_paths = sorted(glob.glob(osp.join(dataset_path, "*")))

    if len(case_paths) == 0:
        raise ValueError("{} find no case!".format(case_paths))

    for case_path in case_paths:
        init_output_path = osp.join(case_path, "init")
        os.makedirs(init_output_path, exist_ok=True)
        print(f"Generate initialization for {osp.basename(case_path)}")
        cmd = f"CUDA_VISIBLE_DEVICES={device} python data_generator/init_gaussian.py --data {case_path} --output {init_output_path}"
        init_args = vars(init_parser)
        for var in init_args:
            cmd += f" --{var} {init_args[var]}"
        os.system(cmd)
        print(f"Initialization for {osp.basename(case_path)} complete")


if __name__ == "__main__":
    # fmt: off
    parser = argparse.ArgumentParser()
    init_parser = InitParams(parser)
    parser.add_argument("--data", default="data/cone_ntrain_50_angle_360", type=str, help="Path to dataset.")
    parser.add_argument("--device", default=0, type=int, help="GPU device.")
    # fmt: on

    args = parser.parse_args()
    main(args, init_parser.extract(args))
