# Installation

To install this package, run the following commands from this directory

```bash
conda create -y -n failure_prediction python=3.9
conda activate failure_prediction
pip install -e .
pip install -r requirements.txt
```

# Reproducing experiments

The three experimental environments in our paper can be run using the following commands:

```bash
python failure_prediction/experiments/power_systems/solve_scacopf.py
python failure_prediction/experiments/hide_and_seek/solve_hide_and_seek.py
python failure_prediction/experiments/formation2d/solve.py
```

In both cases, the results will be saved to the `results` directory, likely overwriting some of the pre-optimized solutions we include for convenience.

All experiments support the following command-line flags. If these flags are not specified, sensible defaults will be used for each experiment to re-create some of the results presented in our paper.

```
--dp_mcmc_step_size 1e-6: sets the MCMC step size used for design parameters
--ep_mcmc_step_size 1e-2: sets the MCMC step size used for design parameters
--num_rounds 100: sets the number of predict-then-mitigate rounds to use
--num_mcmc_steps_per_round 10: sets the number of MCMC or gradient descent substeps to use in reach round
--num_chains 10: sets the population size for both design and exogenous parameters
--quench_rounds 10: if using our method, sets the number of rounds at the end of the optimization process to use for quenching, as described in our paper
--disable_gradients: if used, reduces our method to RMH by disabling gradients.
--disable_stochasticity: if used, reduces our method to gradient descent by disabling stochastic effects.
--no-repair: if used, disables the mitigation step (fixed design parameters)
--no-predict: if used, disables the prediction step (fixed exogenous parameters)
--temper: if used, enables tempering
--dp_grad_clip 10.0: if used, clips the gradients of design and exogenous parameters to this value (default is infinity if not specified; i.e. no clipping)
--ep_grad_clip 10.0: if used, clips the gradients of design and exogenous parameters to this value (default is infinity if not specified; i.e. no clipping)
```

The default is to run our proposed method with gradient-based MCMC for both failure prediction and mitigation. To use RMH MCMC instead, use the `--disable_gradients` flag. To run the GD baseline for both prediction and mitigation, use the `--disable_gradients` flag. To run the DR baseline for mitigation only, use the `--disable_gradients --no-predict` flags. To run only failure prediction (no mitigation), add the `--no-repair` flag.

The power grid example also supports the following command-line options

```
--case_name case14: the name of the network to use (either case14 or case57)
--L 100.0: the penalty factor to apply to constraint violations
```

The hide and seek example also supports the following command-line options

```
--n_seekers 2: number of seekers
--n_hiders 2: number of hiders
--T 5: number of control points in each trajectory
--width 3.2: width of arena (m)
--height 2.0: height of arena (m)
--buffer 0.2: sensing radius of seekers
--duration 50.0: duration of simulation
```

The formation example also supports the following command-line options

```
--n 5: number of agents
--T 3: number of control points in each trajectory
--width 3.2: width or arena (m)
--height 3.0: height of arena (m)
--R 0.5: communication radius
--max_wind_thrust 0.5: maximum thrust from wind
--duration 30.0: duration of simulation
```

The code for deploying the hide and seek examples on HW is not included, but it follows the published [Robotarium examples](https://www.robotarium.gatech.edu/tutorial) closely.
