# -*- coding: utf-8 -*-
# Author: Runsheng Xu <rxx3386@ucla.edu>
# License: TDG-Attribution-NonCommercial-NoDistrib

from opencood.data_utils.datasets.late_fusion_dataset_ori import LateFusionDataset
from opencood.data_utils.datasets.early_fusion_dataset import EarlyFusionDataset
from opencood.data_utils.datasets.intermediate_fusion_dataset import IntermediateFusionDataset
from opencood.data_utils.datasets.intermediate_fusion_dataset_v2 import IntermediateFusionDatasetV2
from opencood.data_utils.datasets.intermediate_fusion_dataset_dair import IntermediateFusionDatasetDAIR
from opencood.data_utils.datasets.intermediate_fusion_dataset_dair_v2 import IntermediateFusionDatasetDAIRV2
from opencood.data_utils.datasets.late_fusion_dataset_dair import LateFusionDatasetDAIR

__all__ = {
    'LateFusionDataset': LateFusionDataset,
    'EarlyFusionDataset': EarlyFusionDataset,
    'IntermediateFusionDataset': IntermediateFusionDataset,
    'IntermediateFusionDatasetV2': IntermediateFusionDatasetV2,
    'IntermediateFusionDatasetDAIR': IntermediateFusionDatasetDAIR,
    'IntermediateFusionDatasetDAIRV2':IntermediateFusionDatasetDAIRV2,
    'LateFusionDatasetDAIR':LateFusionDatasetDAIR,
}

# the final range for evaluation
# GT_RANGE = [-76.5, -76.5, -5, 76.5, 76.5, -1]
GT_RANGE = []

V_GT_RANGE = []
I_GT_RANGE = []

# The communication range for cavs
COM_RANGE = 0

def build_dataset(dataset_cfg, visualize=False, work=True):
    assert work in ['train', 'val', 'test']
    dataset_name = dataset_cfg['fusion']['core_method']
    error_message = f"{dataset_name} is not found. " \
                    f"Please add your processor file's name in opencood/" \
                    f"data_utils/datasets/init.py"
    assert dataset_name in ['LateFusionDataset', 
                            'EarlyFusionDataset',
                            'IntermediateFusionDataset', 'IntermediateFusionDatasetV2',
                            'IntermediateFusionDatasetDAIR', 'IntermediateFusionDatasetDAIRV2',
                            'LateFusionDatasetV2XSim', 'LateFusionDatasetDAIR'], error_message
    
    global GT_RANGE 
    GT_RANGE= dataset_cfg['preprocess']['lidar_range'] if 'lidar_range' in dataset_cfg['preprocess'] else None
    
    global V_GT_RANGE 
    V_GT_RANGE= dataset_cfg['preprocess']['v_lidar_range'] if 'v_lidar_range' in dataset_cfg['preprocess'] else None

    global I_GT_RANGE 
    I_GT_RANGE= dataset_cfg['preprocess']['i_lidar_range'] if 'i_lidar_range' in dataset_cfg['preprocess'] else None
    
    global COM_RANGE
    if dataset_name == 'IntermediateFusionDatasetV2XSim' or dataset_name == 'LateFusionDatasetV2XSim':
        COM_RANGE = 50
    else:
        COM_RANGE = 70

    dataset = __all__[dataset_name](
        params=dataset_cfg,
        visualize=visualize,
        work=work
    )

    return dataset
