import spconv
import spconv.pytorch

def ConvertSparseTensor(x):
    # x: B H W C
    B, H, W, C = x.shape
    
    x = x.to_sparse(3)

    if not x.is_coalesced():
        x = x.coalesce()
        
    indices = x.indices().permute(1, 0).contiguous()
        
    feature = x.values().view(-1, C)

    x = spconv.pytorch.SparseConvTensor(feature, indices.int(), [H, W], B)

    return x