import numpy as np

import torch

def great_circle_distance_loss(x, y, eps=1e-6):
    return torch.arccos(torch.clamp(torch.sin(x[:, 0] * 0.5 * torch.pi) * torch.sin(y[:, 0] * 0.5 * torch.pi) + torch.cos(x[:, 0] * 0.5 * torch.pi) * torch.cos(y[:, 0] * 0.5 * torch.pi) * torch.cos(torch.abs(x[:, 1] - y[:, 1]) * torch.pi), min=-1+eps, max=1-eps))

def great_circle_distance_numpy(x, y, eps=1e-8):
    return np.arccos(np.clip(np.sin(x[:, 0] * 0.5 * np.pi) * np.sin(y[:, 0] * 0.5 * np.pi) + np.cos(x[:, 0] * 0.5 * np.pi) * np.cos(y[:, 0] * 0.5 * np.pi) * np.cos(np.abs(x[:, 1] - y[:, 1]) * np.pi), a_min=-1+eps, a_max=1-eps))

