import argparse
from src.experiments import run_experiment
from rpy2.robjects import pandas2ri

pandas2ri.activate()


def run(args):
    run_experiment(args.path_dir, args)


def parse_arguments():
    parser = argparse.ArgumentParser(description="Configure the evaluation pipeline")

    parser.add_argument(
        "--path_dir", "-pd", type=str, required=True, help="Path to dir to read files"
    )
    parser.add_argument(
        "--max_depth",
        "-md",
        type=int,
        default=5,
        help="Maximum depth for tree-based experiments",
    )
    parser.add_argument(
        "--save_path", "-sp", type=str, required=True, help="Path to save results"
    )
    parser.add_argument(
        "--dataset",
        "-ds",
        type=str,
        required=False,
        help="Name of the dataset",
        default=None,
    )
    # with dependencies
    parser.add_argument(
        "--dependency",
        "-dep",
        type=bool,
        required=False,
        help="Name of the dependency",
        default=False,
    )
    parser.add_argument(
        "--discret_threshold", "-dt", type=float, default=0.49
    )  # 0.49-0.90
    parser.add_argument("--discount", "-dc", type=float, default=0.75)  # 75-90
    parser.add_argument("--train_size", "-ts", type=float, default=0.5)  # 75-90
    parser.add_argument("--test_size", "-tes", type=float, default=0.5)  # 75-90
    parser.add_argument("--amount_seeds", "-as", type=float, default=10)  # 75-90

    parser.add_argument("--cores", "-c", type=int, default=4)
    return parser.parse_args()


if __name__ == "__main__":
    args = parse_arguments()
    if args.train_size + args.test_size > 1.0:
        raise ValueError("Train and test size should not exceed 1.0")
    run(args)
