# function to calculate a bicop in a given vine

######### helper functions
sanity_check <- function(m, tr, cn){
  d <- unname(dim(m)[1])
  if(!(tr==floor(tr)) || !(cn==floor(cn))){stop("tree and or copnum must be integer")}
  if(tr <= 0){stop("tree does not exist")}
  if(cn > d-tr){stop("copnum does not exist in this tree")}
}

get_right_arg <- function(m, tr, cn){

  return(m[ tr, cn])
}

get_left_arg <- function(m, tr, cn){
  d <- dim(m)[1]

  return(m[ (d+1-cn), cn])
}

get_args <- function(m, tr, cn){

  return(c(get_left_arg(m, tr, cn), get_right_arg(m, tr, cn)))
}

get_cond <- function(m, tr, cn){
  if(tr == 1){ return(c())}

  return(m[ rev((1:(tr-1))), cn])
}

get_info <- function(m, tr, cn){
  sanity_check(m, tr, cn)
  return(list(left_arg = get_left_arg(m, tr, cn),
              right_arg = get_right_arg(m, tr, cn),
              cond_set = get_cond(m, tr, cn),
              tree = tr,
              copnum = cn,
              dim = unname(dim(m)[1])))
}

# find out which cop needs to be conditioned on which arg
cond_onwhat <- function(uppercop, undercop){
  if(undercop[[1]] == uppercop[[1]]|| undercop[[1]] == uppercop[[2]]){
    return(2)
  }
  return(1)
}

# find cops below
cops_below <- function(m, tr, cn){

  if(tr == 1){stop("there are no cops below, tree == 1")}
  info <- get_info(m, tr, cn)
  soll <- c(info$right_arg, info$cond_set)

  for(i in 1:(dim(m)[1]-tr+1)){
    if(i == cn){ next }
    info_neu <- get_info(m, tr-1, i)
    ist <- c(info_neu$right_arg, info_neu$left_arg, info_neu$cond_set)
    if(setequal(soll, ist)){
      return(list(get_info(m, tr-1, cn), info_neu))
    }
  }
  stop("cop below not found")
}

# get the number of a copula in cops_list
get_cop <- function(cop_info){
  tree <- cop_info$tree
  cn <- cop_info$copnum
  dim <- unname(cop_info$dim)

  # how many pair copulas in the lower trees
  temp <- (tree-1)*dim - ( (tree*(tree-1)) / 2)

  # add number in current tree to get position in cops_list
  return(temp + cn)
}

############################
# end helper funcs

# function to determine arguments to copulas in higher trees
bicop_arg <- function(cops_list, current_position, m, indata){

  # extract tree and copnum
  tree <- current_position[1]
  copnum <- current_position[2]

  # get info of current copula
  info <- get_info(m, tree, copnum)

  # if in tree one, return original margins
  if(info$tree == 1){
    return(indata[ , c(info$left_arg, info$right_arg)])
  }

  # else: recursively apply function until in tree one
  cops_low <- cops_below(m, tree, copnum)
  return( cbind(
  rvinecopulib::hbicop(bicop_arg(cops_list[1:get_cop(cops_low[[1]])],
                   c(cops_low[[1]][["tree"]], cops_low[[1]][["copnum"]]),
                   m,
                   indata),
         cond_var = cond_onwhat(info, cops_low[[1]]),
         cops_list[[ get_cop(cops_low[[1]]) ]]),

  rvinecopulib::hbicop(bicop_arg(cops_list[1:get_cop(cops_low[[2]])],
                   c(cops_low[[2]][["tree"]], cops_low[[2]][["copnum"]]),
                   m,
                   indata),
         cond_var = cond_onwhat(info, cops_low[[2]]),
         cops_list[[ get_cop(cops_low[[2]]) ]])
  )
  )
}

