#### script to test outlier score based on bivariate sample

# define outlier function for sample
outlscore_maker_fit <- function(indata,
                                calc_fit,
                                dependence,
                                discr_thresh,
                                n_eval,
                                discount,
                                trunclvl,
                                famset,
                                parmethod,
                                ncores,
                                verbose){

  ###########################################################
  ####################### marginals #########################
  ###########################################################

  if(!verbose){print("begin margin fits")}

  # parallel execution if requested
  if(ncores > 1){
    cl <- parallel::makeCluster(ncores, type = "FORK")
    doParallel::registerDoParallel(cl)
    `%myop%` <- `%dopar%`
  } else {
    `%myop%` <- `%do%`
  }

  margins <- foreach::foreach(i = 1:dim(indata)[2]) %myop%
        marg_outl_fit(indata = indata[, i],
                      grid_size = n_eval,
                      discr_thresh = discr_thresh,
                      calc_fit = calc_fit)

  if(ncores > 1){
    parallel::stopCluster(cl)
  }

  if(!verbose){print("end margin fits")}

  if(!dependence){
    return(list("margins" = margins,
                "cops" = NULL))
  }

  ###########################################################
  ################ dependence structure #####################
  ###########################################################

  if(!verbose){print("begin dependence fit, data trafo")}

  # which variables are continuous-like
  c_vars <- which(sapply(margins, function(x) !x[["d_flag"]]))

  if(length(c_vars) < 2){
    return(list("margins" = margins,
                "cops" = NULL))
  }

  # transform data to u scale
  uscaled_data <- apply(matrix(c_vars, nrow = 1),
                        2,
                        function(x) kde1d::pkde1d(q = indata[, x],
                                                  obj = margins[[x]][["fit"]]))

  # fit the vine copula
  if(!verbose){print("fit vine copula")}
  vcfit <- rvinecopulib::vinecop(uscaled_data,
                   family_set = famset,
                   par_method = parmethod,
                   psi0 = discount,
                   presel = T,
                   tree_crit = "tau",
                   trunc_lvl = trunclvl,
                   threshold = 0,
                   cores = ncores,
                   keep_data = F)

  # extract copulas and add tree and copnum info
  cops_list <- list()
  pos_list <- list()
  pos <- 1
  for(i in 1:length(vcfit$pair_copulas)){
    for(j in 1:length(vcfit$pair_copulas[[i]])){
      cops_list[[pos]] <- vcfit$pair_copulas[[i]][[j]]
      pos_list[[pos]] <- c(i, j)
      pos <- pos + 1
    }
  }
  vc_mat <- rvinecopulib::get_matrix(vcfit)
  rm(vcfit)

  # in parallel: fit the copula outlier score functions
  if(!verbose){print("begin dependence outlier funs")}

  if(ncores > 1){
    cl <- parallel::makeCluster(ncores, type = "FORK")
    doParallel::registerDoParallel(cl)
    `%myop%` <- `%dopar%`
  } else {
    `%myop%` <- `%do%`
  }

  cops_outl <- foreach::foreach(i = 1:length(cops_list)) %myop%

    cop_outl_fit(indata = bicop_arg(cops_list = cops_list[1:i],
                                    current_position = pos_list[[i]],
                                    m = vc_mat,
                                    indata = uscaled_data),
                 incop = cops_list[[i]],
                 position = pos_list[[i]],
                 lrarg = get_args(m = vc_mat,
                                  tr = pos_list[[i]][1],
                                  cn = pos_list[[i]][2]),
                 cond = get_cond(m = vc_mat,
                                 tr = pos_list[[i]][1],
                                 cn = pos_list[[i]][2]),
                 n_eval = n_eval,
                 discount = discount,
                 parmethod = parmethod,
                 calc_fit = calc_fit)

  if(ncores > 1){
    parallel::stopCluster(cl)
  }

  if(!verbose){print("end dependence outlier funs")}

  return(list("margins" = margins,
              "cops" = cops_outl,
              "vc_mat" = vc_mat))
}


### outlierscores for test data
outlscore_maker <- function(new_data,
                            ncores,
                            vcb_fit,
                            verbose){

  # calculate marginal scores
  if(!verbose){print("begin margins")}

  if(ncores > 1){
    cl <- parallel::makeCluster(ncores, type = "FORK")
    doParallel::registerDoParallel(cl)
    `%myop%` <- `%dopar%`
  } else {
    `%myop%` <- `%do%`
  }

  margins <- foreach::foreach(i = 1:dim(new_data)[2]) %myop%
    marg_outl(indata = new_data[, i],
              fit_info = vcb_fit[["misc"]][["margins"]][[i]])

  if(ncores > 1){
    parallel::stopCluster(cl)
  }

  if(!verbose){print("end marginals")}

  # calculate dependence score, if asked for
  cops <- NULL
  if(vcb_fit[["dep_vc"]] > 0){
    if(!verbose){print("begin dependence, data trafo")}

    # which variables are continuous-like
    c_vars <- which(sapply(vcb_fit[["misc"]][["margins"]],
                           function(x) !x[["d_flag"]]))

    # transform data to u scale
    new_data_uscale <- apply(matrix(c_vars, nrow = 1), 2,
                             function(x) kde1d::pkde1d(q = new_data[, x],
                  obj = vcb_fit[["misc"]][["margins"]][[x]][["fit"]]))

    if(is.vector(new_data_uscale)){new_data_uscale <- t(new_data_uscale)}

    if(!verbose){print("begin dependence outlier scores")}

    signif_cops <- sapply(vcb_fit[["misc"]][["cops"]],
                          function(x) if(x[["signif"]] > 0){1}else{0})

    if(ncores > 1){
      cl <- parallel::makeCluster(ncores, type = "FORK")
      doParallel::registerDoParallel(cl)
      `%myop%` <- `%dopar%`
    } else {
      `%myop%` <- `%do%`
    }

    cops <- foreach::foreach(i = which(signif_cops == 1)) %myop%
      cop_outl(indata = bicop_arg(cops = lapply(vcb_fit[["misc"]][["cops"]],
                                                function(x) x[["cop"]])[1:i],
                                  current_position = vcb_fit[["misc"]][["cops"]][[i]][["position"]],
                                  m = vcb_fit[["misc"]][["vc_mat"]],
                                  indata = new_data_uscale),
               fit_info = vcb_fit[["misc"]][["cops"]][[i]])

    if(ncores > 1){
      parallel::stopCluster(cl)
    }

    if(!verbose){print("end dependence outlier scores")}
  }

  return(list("margins" = margins,
              "cops" = cops))
}
