import pandas as pd
from utils.data import read_nat_to_numpy, get_files_in_dir

pd.set_option("display.max_rows", None)


def analyse_optimal_tree_experiment(file_path: str):
    data = pd.read_csv(file_path)

    average_precision_scores = data.groupby(["tree_depth", "measure_type"])[
        "f1_ratio"
    ].mean()
    print(average_precision_scores)


def analyse_optimal_tree_experiment_dataset(file_path: str):
    data = pd.read_csv(file_path)

    average_precision_scores = data.groupby(["dataset", "measure_type", "tree_depth"])[
        "f1_ratio"
    ].max()

    print(data.groupby(["measure_type", "tree_depth"])["roc_auc_score"].mean())

    print(average_precision_scores)


def analyse_hyper_experiment_dataset(file_path: str):
    data = pd.read_csv(file_path)

    f1_ratio_mean = data.loc[data["f1_ratio_mean"].idxmax()]
    print("Max f1_ratio_mean", f1_ratio_mean)

    print("Min roc auc score", data.loc[data["f1_ratio_mean"].idxmin()])


def show_data(path):
    data = read_nat_to_numpy(path)
    print(data["X"])


if __name__ == "__main__":
    file_path = "./results/optimal_tree_results_all.csv"
    new_file_path = "./results/optimal_hyperparemter_tree3_dsabalone.csv"
    # analyse_optimal_tree_experiment(file_path)
    analyse_optimal_tree_experiment_dataset(file_path)
    analyse_hyper_experiment_dataset(new_file_path)
