#!/bin/bash

# vcbod Setup Script

# Function to print a message with a timestamp
print_message() {
    echo "[$(date +"%Y-%m-%d %H:%M:%S")] $1"
}

print_message "Starting setup..."

# Step 1: Data Collection
print_message "Collecting data using script..."
make get_data

# Step 2: Python Environment Setup
print_message "Setting up Python virtual environment..."

# Ensure Python is installed
if ! command -v python3 &>/dev/null; then
    print_message "Python3 could not be found. Please install Python3 and try again."
    exit 1
fi

# Create virtual environment
python3 -m venv .venv

# Activate virtual environment
source .venv/bin/activate

# Step 3: Install Python dependencies
print_message "Installing required Python packages..."
pip install -r requirements.txt

# Setp 4: Create Results Directory
print_message "Creating results directory..."
mkdir -p results

# Step 4: R Installation (for MacOS and Debian/Ubuntu)

# Detect OS
OS=$(uname)

if [ "$OS" == "Darwin" ]; then
    # MacOS
    print_message "Detected macOS. Installing R via Homebrew..."
    if ! command -v brew &>/dev/null; then
        print_message "Homebrew is not installed. Please install Homebrew and rerun this script."
        exit 1
    fi
    brew install --cask r
elif [ "$OS" == "Linux" ]; then
    # Linux (Assume Debian/Ubuntu)
    print_message "Detected Linux. Installing R via APT..."

    # Add R repository and install R
    sudo apt install -y software-properties-common
    sudo apt-key adv --keyserver keyserver.ubuntu.com --recv-keys E084DAB9
    sudo add-apt-repository 'deb https://cloud.r-project.org/bin/linux/ubuntu focal-cran40/'
    sudo apt update
    sudo apt install -y r-base
else
    print_message "Unsupported OS. Please install R manually."
    exit 1
fi



print_message "Setup complete!"