### kernel density estimator for marginal distributions
### applicable if data continuous

##### helper funs

grid_dense_maker <- function(grid_size,
                             fit,
                             indata_dense){

  # number of evaluation points
  how_many <- grid_size^2

  # where to evaluate density
  grid <- kde1d::qkde1d(seq(1/(how_many*1),
                            1-(1/(how_many*1)),
                            length.out = how_many),
                        fit)

  # evaluate density
  return(sort(kde1d::dkde1d(grid, fit)))
}

# calculate sample score
# offset only used for mixed data
conti_scores <- function(indata_dense,
                         grid_dense){

  # save order of data to reverse later
  indata_order <- order(indata_dense)
  indata_dense <- indata_dense[indata_order]

  n_grid <- length(grid_dense)
  thresh <- (n_grid)^-1
  b <- thresh^-1

  # calculate outlier scores of data
  sample_scores <- rep(0, length(indata_dense))
  pos <- 1
  temp <-1
  for(i in 1:length(indata_dense)){
    temp <- Position(function(x) x > indata_dense[i], grid_dense[pos:n_grid])
    if(is.na(temp)){
      sample_scores[i:length(sample_scores)] <- 0
      break
    } else {
      temp2 <- ((temp+pos-2) / n_grid)
      if(temp2 <= thresh){
        sample_scores[i] <- 1
      } else {
        sample_scores[i] <- -0.99*log(temp2, base = b)
      }
    }
    pos <- pos + temp - 1
  }

  return(sample_scores[order(indata_order)])
}


marg_conti_fit <- function(indata,
                            grid_size,
                            calc_fit){

  # fit kernel to data
  fit <- kde1d::kde1d(indata)

  # calculate densities of sample
  indata_dense <- kde1d::dkde1d(indata, fit)

  # calculate grid
  grid_dense <- grid_dense_maker(grid_size = grid_size,
                                 fit = fit)

  # calc sample scores if asked for
  if(calc_fit){
    sample_scores <- conti_scores(indata_dense = indata_dense,
                                        grid_dense = grid_dense)
  } else {
    sample_scores <- c()
  }

  return(list("d_flag" = FALSE,
              "fit" = fit,
              "grid_dense" = grid_dense,
              "sample_scores" = sample_scores))

}






