### script to calculate outlier score of marginals

# the function used for fitting to training data
marg_outl_fit <- function(indata,
                          grid_size = 100,
                          discr_thresh = 0.1,
                          calc_fit = T){

      # check if input is concentrated on one or more points
      # in that case different marginal approach and
      # no copula analysis
      d_flag <- (max(table(as.factor(indata)))/length(indata) > discr_thresh)

      # for continuous-like data
      if(!d_flag){
        return(marg_conti_fit(indata = indata,
                              grid_size = grid_size,
                              calc_fit = calc_fit))
      }

      # for discrete or mixed data
      return(marg_discr_fit(indata = indata,
                            discr_thresh = discr_thresh,
                            calc_fit = calc_fit,
                            grid_size = grid_size))

}

# the function used on fresh, unseen data
# input argument out1 is output from marg_outl_fit
marg_outl <- function(indata, fit_info){

  # for continuous-like data
  if(!fit_info[["d_flag"]]){
    return(list("sample_scores" = conti_scores(indata_dense = kde1d::dkde1d(indata,
                                                    obj = fit_info[["fit"]]),
                                    grid_dense = fit_info[["grid_dense"]]),
                "d_flag" = fit_info[["d_flag"]]))
  }

  # for discrete or mixed data
  return(list("sample_scores" = discr_scores(indata = indata,
                                           fit_info = fit_info),
              "d_flag" = fit_info[["d_flag"]]))
}
