from sklearn.metrics import (
    roc_auc_score,
    recall_score,
    precision_score,
    precision_recall_curve,
)
from sklearn.metrics import precision_recall_fscore_support as prf
import numpy as np


def get_metrics_preds(y_true, preds):

    preds_n = preds
    y_true = y_true.astype("int")
    outlier_ratio = 100.0 * (1.0 - ((y_true.sum() / len(y_true))))
    thresh = np.percentile(preds_n, outlier_ratio)
    target_pred = (preds_n >= thresh).astype(int)
    (_, _, f1_ratio, _) = prf(y_true, target_pred, average="binary")
    roc_auc = roc_auc_score(y_true, target_pred)
    ap = precision_score(y_true, target_pred)
    rc = recall_score(y_true, target_pred)
    precisions, recalls, thresholds = precision_recall_curve(y_true, preds_n)

    f1s = 2 * (precisions * recalls) / (precisions + recalls)
    f1s = np.nan_to_num(f1s, nan=0.0)

    idx_best_f1 = np.argmax(f1s)
    best_f1 = f1s[idx_best_f1]

    return {
        "recall": rc,
        "roc_auc": roc_auc,
        "f1_max": best_f1,
        "f1_ratio": f1_ratio,
        "precision": ap,
    }
