import configparser
import sys
import os # osモジュールをインポート

# --- このファイル(_src.py)の絶対パスを取得 ---
_THIS_FILE_PATH = os.path.abspath(__file__)

# --- プロジェクトのルートディレクトリを計算 ---
# /work/keisuke-o/ws/c-bbo/experiments/_src.py -> /work/keisuke-o/ws/c-bbo
PROJECT_DIR = os.path.dirname(os.path.dirname(_THIS_FILE_PATH))

# --- config.iniへの絶対パスを構築 ---
config_path = os.path.join(PROJECT_DIR, "config.ini")

print(f"[_src.py] Attempting to read config from: {config_path}")

# Load configuration
config = configparser.ConfigParser()
config.read(config_path)

# --- configファイルが見つかったか、セクションが存在するかをチェック ---
if 'paths' not in config:
    raise KeyError(f"'[paths]' section not found in config file: {config_path}. Check the file content and path.")

# 以下の部分は変更なし
LOG_DIR = config["paths"]["logs_dir"]
DB_DIR = config["paths"]["dbs_dir"]
sys.path.append(PROJECT_DIR)

from src.objectives.warcraft import ConstraintWarcraft, get_map
from src.objectives.warcraft import WarcraftObjectiveTF
from src.objectives.warcraft import WarcraftObjectiveBenchmark
from src.objectives.eggholder import EggholderBenchmark, EggholderTF
from src.objectives.ackley import AckleyBenchmark, AckleyTF
from src.samplers.tf_continual import TFContinualSampler
from src.samplers.tf_sdpa import TFSdpaSampler
from src.samplers.gp import GPSampler
from src.utils_experiments import set_logger, parse_experiment_path

from src.objectives.diabetes import DiabetesObjective
from src.objectives.pressure import PressureVesselObjective
from src.samplers.tf_continual_ablation import TFContinualAblationSampler
from src.objectives.gap import GAP_A_Objective, GAP_B_Objective
from src.objectives.ising import Ising_A_Objective, Ising_B_Objective
from src.objectives.nats import TSSObjective, SSSObjective

from src.tensor_factorization_continual import TensorFactorization
from src.protes import Protes

__all__ = [
    "WarcraftObjectiveTF",
    "WarcraftObjectiveBenchmark",
    "ConstraintWarcraft",
    "EggholderBenchmark",
    "EggholderTF",
    "AckleyBenchmark",
    "AckleyTF",
    "TFContinualSampler",
    "TFSdpaSampler",
    "GPSampler",
    "set_logger",
    "get_map",
    "parse_experiment_path",
    "DiabetesObjective",
    "PressureVesselObjective"
    "TFContinualAblationSampler",
    "GAP_A_Objective",
    "GAP_B_Objective",
    "Ising_A_Objective",
    "Ising_B_Objective",
    "TSSObjective",
    "SSSObjective",
    "TensorFactorization",
    "Protes"
]