#!/bin/bash
# --- このスクリプト自身のディレクトリを取得 ---
SCRIPT_DIR=$(cd -- "$(dirname -- "$0")" &>/dev/null && pwd)
# --- プロジェクトのルートディレクトリを計算 ---
# SCRIPT_DIRから2階層上がることでプロジェクトルートを取得
PROJECT_ROOT=$(cd "$SCRIPT_DIR/../.." &>/dev/null && pwd) 

# --- このランチャー実行全体で共有するタイムスタンプと保存先を定義 ---
LAUNCH_TIMESTAMP=$(date +"%Y%m%d_%H%M%S")
SAVEDIR="$PROJECT_ROOT/results_protes_benchmark_${LAUNCH_TIMESTAMP}"

mkdir -p "$SAVEDIR" "$SAVEDIR/logs"
cp "$SCRIPT_DIR/$(basename "$0")" "$SAVEDIR/launch.sh_snapshot"
# Also copy the job script for reproducibility
cp "$PROJECT_ROOT/scripts/scripts_protes/run_protes_job.sh" "$SAVEDIR/run_protes_job.sh_snapshot"

==========================================================
              EXPERIMENT CONFIGURATION
==========================================================
--- 試したい実験を "関数名:マップオプション:制約フラグ" の形式で記述 ---
EXPERIMENTS_TO_RUN=(
  "diabetes::constraint"
  "pressure::constraint"
  "warcraft:1:constraint"
  "warcraft:2:constraint"
  "gap_a::no_constraint"
  "gap_b::no_constraint"
  "ising_a::no_constraint"
  "ising_b::no_constraint"
  "tss::constraint"
  "sss::constraint"
  "ackley::constraint"
)
# EXPERIMENTS_TO_RUN=(
#   "diabetes"
#   "pressure"
#   "warcraft:1"
#   "warcraft:2"
#   "gap_a"
#   "gap_b"
#   "ising_a"
#   "ising_b"
#   "tss"
#   "sss"
#   "ackley"
# )

SEEDS_TO_RUN=(0 1 2 3 4 5 6 7 8 9)
# ==========================================================

echo "Project Root: $PROJECT_ROOT"
echo "Saving results in: $SAVEDIR"
echo "Submitting jobs..."

for experiment in "${EXPERIMENTS_TO_RUN[@]}"; do
  IFS=':' read -r func_name map_opt constraint_flag <<< "$experiment"
  for seed in "${SEEDS_TO_RUN[@]}"; do
    
    JOB_NAME="${func_name}_seed${seed}"
    if [ ! -z "$map_opt" ]; then JOB_NAME="${func_name}_map${map_opt}_seed${seed}"; fi
    if [[ "$constraint_flag" == "constraint" ]]; then JOB_NAME+="_constrained"; fi

    SBATCH_ARGS=("$func_name" "$seed" "$LAUNCH_TIMESTAMP" "$SAVEDIR" "$map_opt" "$constraint_flag")

    echo "Submitting job: $JOB_NAME"
    
    sbatch --job-name="$JOB_NAME" \
           --output="$SAVEDIR/logs/${JOB_NAME}_%A.out" \
           --error="$SAVEDIR/logs/${JOB_NAME}_%A.err" \
           --chdir="$PROJECT_ROOT" \
           "scripts/scripts_protes/run_protes_job.sh" "${SBATCH_ARGS[@]}"
  done
done

echo "All jobs have been submitted."