#!/bin/bash -l
#SBATCH --job-name=protes_bench
#SBATCH --partition=cluster_short
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --cpus-per-task=4
#SBATCH --mem=8G
#SBATCH --time=01:00:00

#SBATCH --output=logs/protes_%x_%A.out
#SBATCH --error=logs/protes_%x_%A.err

### --- Check for arguments from launcher --- ###
if [ "$#" -lt 6 ]; then
  echo "Error: Invalid number of arguments."
  echo "Usage: sbatch $0 <FUNC> <SEED> <TIMESTAMP> <SAVEDIR> <MAP_OPT> <CONST_FLAG>"
  exit 1
fi
FUNCTION_NAME=$1
SEED=$2
SHARED_TIMESTAMP=$3
BASE_SAVEDIR=$4
MAP_OPTION=$5
CONSTRAINT_FLAG=$6

### --- Prepare environment (activate your conda/venv) --- ###
# 例: source /path/to/your/venv/or/conda/bin/activate
# 例: conda activate your_env_name
echo "Environment prepared."

### --- Log received arguments --- ###
echo "Job started on $(hostname) at $(date)"
echo "Current working directory: $(pwd)"
echo "--- Arguments ---"
echo "FUNCTION_NAME: $FUNCTION_NAME"
echo "SEED: $SEED"
echo "SHARED_TIMESTAMP: $SHARED_TIMESTAMP"
echo "BASE_SAVEDIR: $BASE_SAVEDIR"
echo "MAP_OPTION: $MAP_OPTION"
echo "CONSTRAINT_FLAG: $CONSTRAINT_FLAG"

### --- Build argument array for the Python script --- ###
declare -a FLAGS=(
  --timestamp        "$SHARED_TIMESTAMP"
  --seed             "$SEED"
  --base_dir         "$BASE_SAVEDIR"
  --function         "$FUNCTION_NAME"
  --iter_bo          500
  --protes_rank      3
  --protes_k_batch   1
  --protes_k_top     1 
  --protes_k_gd      100 
  --protes_lr        0.01
)

### --- Add function-specific and constraint flags --- ###
if [[ "$CONSTRAINT_FLAG" == "constraint" ]]; then
  FLAGS+=(--constraint)
fi

if [[ "$FUNCTION_NAME" == "gap_a" || "$FUNCTION_NAME" == "gap_b" ]]; then
  FLAGS+=(--direction)
fi

if [[ "$FUNCTION_NAME" == "warcraft" ]]; then
  if [ -z "$MAP_OPTION" ]; then
    echo "ERROR: MAP_OPTION is missing for warcraft function!"
    exit 1
  fi
  FLAGS+=(--map_option "$MAP_OPTION")
fi

### --- Run the Python experiment script --- ###
# Assuming the python script is at PROJECT_ROOT/experiments/protes.py
PYTHON_SCRIPT="experiments/protes.py" 
echo "--- Running Python Script ---"
echo "Command: python $PYTHON_SCRIPT ${FLAGS[@]}"
echo "Checking if script exists: $(ls -l $PYTHON_SCRIPT)"

python "$PYTHON_SCRIPT" "${FLAGS[@]}"

echo "--- Python Script Finished ---"
echo "Experiment finished for function $FUNCTION_NAME, seed $SEED at $(date)."