# Project Concerto
Concerto is built on the Pointcept codebase. Here, we provide only the components relevant to our project Concerto. For those previous models in Pointcept, we drop them for reading convenience. Currently, for anonymity, all references to names have been omitted.

## Framework
**config**: the pretrain and evaluation config files
- concerto_pretrain: pretrain config
- concerto_semseg_eval: semantic segmentation evaluation configs, add la_file and lr_file(shown in the comments) can do the ScanNet Efficient eval.
- concerto_insseg_eval: instance segmentation evaluation configs.
- concerto_lseg_prob: LSeg language linear probing evaluation configs.

**pointcept**: the main model files of Concerto
- datasets
  - xx_img_all: load point clouds with images. Many datasets are organized in the same way, so they share the single one dataloader.
- models
  - concerto: PTv3 modified to handle the correspondence between pixels and points
  - concerto_pretrain: main pretrain file of intra-modal self-distillation and cross-modal joint embedding prediction, **concerto_v2m2** is the version not wrapping the correspondence into PTv3 while the other **concerto_v2m2_upcast** is the main model file we use.
  - concerto_lseg_pro: linear probing output is aligned with the LSeg image encoder's output for language probing. **zeroshot_concerto_lseg_pro_v1m1** is for the last test, others are for training linear probing
  - Other necessary evaluation files, such as point_group, can be found at the original Pointcept.

**scripts/tools**: running scripts

## data preparation
Evaluation data is the same as Sonata, which is described in the original Pointcept codebase. As for pretraining data, which is quite large, we now do not open access to it. In the near future, we will release the complete data and code.
## installation
### Requirements
- Ubuntu: 18.04 and above.
- CUDA: 11.3 and above.
- PyTorch: 1.10.0 and above.

### Conda Environment

```bash
conda create -n pointcept python=3.8 -y
conda activate pointcept
conda install ninja -y
# Choose version you want here: https://pytorch.org/get-started/previous-versions/
conda install pytorch==1.12.1 torchvision==0.13.1 torchaudio==0.12.1 cudatoolkit=11.3 -c pytorch -y
conda install h5py pyyaml -c anaconda -y
conda install sharedarray tensorboard tensorboardx yapf addict einops scipy plyfile termcolor timm -c conda-forge -y
conda install pytorch-cluster pytorch-scatter pytorch-sparse -c pyg -y
pip install torch-geometric

# spconv (SparseUNet)
# refer https://github.com/traveller59/spconv
pip install spconv-cu113

# PPT (clip)
pip install ftfy regex tqdm
pip install git+https://github.com/openai/CLIP.git

# PTv1 & PTv2 or precise eval
cd libs/pointops
# usual
python setup.py install
# docker & multi GPU arch
TORCH_CUDA_ARCH_LIST="ARCH LIST" python  setup.py install
# e.g. 7.5: RTX 3000; 8.0: a100 More available in: https://developer.nvidia.com/cuda-gpus
TORCH_CUDA_ARCH_LIST="7.5 8.0" python  setup.py install
cd ../..

# Open3D (visualization, optional)
pip install open3d
```
### pretraining
``` bash
sh scripts/train.sh -m 2 -g 8 -d concerto_pretrain -c pretrain-concerto_v2m2_online_alldata_upcast3 -n concerto_pretrain -a $MLP_WORKER_0_HOST -o $MLP_WORKER_0_PORT -i $MLP_ROLE_INDEX -r true
# MLP_WORKER_0_HOST: The address of worker0 (the worker with RANK=0).
# MLP_WORKER_0_PORT: The port of worker0 (the worker with RANK=0).
# MLP_ROLE_INDEX: The ID of the training instance (machine), which has different values in different instances.
```

### evaluation
The evaluation code is not specific to Concerto project. The evaluation code in the original pointcept can also work. Here we provide some examples for understanding.
``` bash
sh scripts/train.sh -g 8 -d concerto_semseg_eval -c semseg-sonata-dino-v1m1-ft-decoder -n semseg-decoder-concerto_pretrain -w exp/concerto_pretrain/concerto_pretrain/model/model_last.pth -r true

sh scripts/train.sh -g 8 -d concerto_insseg_eval -c insseg-sonata-dino-v1m1-ft-decoder -n insseg-decoder-concerto_pretrain -w exp/concerto_pretrain/concerto_pretrain/model/model_last.pth -r true
```
---

## Acknowledgement and Citation
We cite the pointcept work here.
```
@misc{pointcept2023,
    title={Pointcept: A Codebase for Point Cloud Perception Research},
    author={Pointcept Contributors},
    howpublished = {\url{https://github.com/Pointcept/Pointcept}},
    year={2023}
}
```
