_base_ = ["../_base_/default_runtime.py"]
seed = None
crop_h = 480
crop_w = 480
patch_size = 2
# misc custom setting
# batch_size = 16  # bs: total bs in all gpus
# num_worker = 16
batch_size = 64  # bs: total bs in all gpus
num_worker = 96
mix_prob = 0
clip_grad = 3.0
# empty_cache = False
empty_cache = True
enable_amp = True
amp_dtype = "bfloat16"
evaluate = True
# evaluate = False
# find_unused_parameters = False
find_unused_parameters = True

only_weight_backbone = True
# only_weight_backbone = False
# model settings
model = dict(
    type="LSegImgAligner",
    DINOhead_in_channels=512,
    ignore_index=(-1,),
    up_cast_level=4,
    freeze_backbone=True,
    patch_h=crop_h // patch_size,
    patch_w=crop_w // patch_size,
    image_weight_name="clip_vitl16_384",
    image_weight_path="models/lang-seg-main/lseg.ckpt",
    backbone_out_channels=1232,
    enc_mode=True,
    sonata_load=False,
    concerto_path="model/model_last.pth",
    MLP_mode=False,
    backbone=dict(
        type="Sonata-PTv3-v2m1",
        in_channels=9,
        order=("z", "z-trans", "hilbert", "hilbert-trans"),
        stride=(2, 2, 2, 2),
        enc_depths=(3, 3, 3, 12, 3),
        enc_channels=(48, 96, 192, 384, 512),
        enc_num_head=(3, 6, 12, 24, 32),
        enc_patch_size=(1024, 1024, 1024, 1024, 1024),
        # dec_depths=(2, 2, 2, 2),
        # dec_channels=(64, 96, 192, 384),
        # dec_num_head=(4, 6, 12, 24),
        # dec_patch_size=(1024, 1024, 1024, 1024),
        mlp_ratio=4,
        qkv_bias=True,
        qk_scale=None,
        attn_drop=0.0,
        proj_drop=0.0,
        drop_path=0.3,
        shuffle_orders=True,
        pre_norm=True,
        enable_rpe=False,
        enable_flash=True,
        upcast_attention=False,
        upcast_softmax=False,
        enc_mode=True,
        # enc_mode=False,
        traceable=True,
        mask_token=False,
        freeze_encoder=True,
    ),
    labels_list=[
        "wall",
        "floor",
        "cabinet",
        "bed",
        "chair",
        "sofa",
        "table",
        "door",
        "window",
        "bookshelf",
        "picture",
        "counter",
        "desk",
        "curtain",
        "refridgerator",
        "shower curtain",
        "toilet",
        "sink",
        "bathtub",
        "otherfurniture",
    ],
    criteria=[
        dict(type="CrossEntropyLoss", loss_weight=1.0, ignore_index=-1),
        # dict(type="LovaszLoss", mode="multiclass", loss_weight=1.0, ignore_index=-1),
    ],
)

# scheduler settings
epoch = 100
eval_epoch = 100
optimizer = dict(type="AdamW", lr=0.002, weight_decay=0.02)
scheduler = dict(
    type="OneCycleLR",
    max_lr=[0.002, 0.0002],
    pct_start=0.05,
    anneal_strategy="cos",
    div_factor=10.0,
    final_div_factor=1000.0,
)
param_dicts = [dict(keyword="block", lr=0.0002)]

# IMAGENET_DEFAULT_MEAN = (0.485, 0.456, 0.406)
# IMAGENET_DEFAULT_STD = (0.229, 0.224, 0.225)
IMAGENET_DEFAULT_MEAN = (0.5, 0.5, 0.5)
IMAGENET_DEFAULT_STD = (0.5, 0.5, 0.5)
INTERPOLATION = "bicubic"
# RESIZE_MODE = "squash"
# dataset settings
transform = [
    dict(
        type="ImgAugmentation",
        crop_h=crop_h,
        crop_w=crop_w,
        patch_h=crop_h // patch_size,
        patch_w=crop_w // patch_size,
        patch_size=patch_size,
        imgtransforms=[
            # dict(type="ImgRandomHorizontalFlip", p=0.5),
            # dict(type="ImgRandomColorJitter", brightness=0.2, contrast=0.2, saturation=0.1, p=0.8),
            # dict(type="ImgRandomGrayscale", p=0.),
            # dict(type="ImgPixelContrast", threshold = 0.02, p=0.5),
            # dict(type="ImgChromaticJitter", p=0.95, std=0.05),
            # dict(type="ImgGaussianBlur", p=0.5),
            # dict(type="ImgToTensor"),
            dict(
                type="Imgnormalize",
                mean=IMAGENET_DEFAULT_MEAN,
                std=IMAGENET_DEFAULT_STD,
            ),
        ],
    ),
    dict(type="CenterShift", apply_z=True),
    dict(type="RandomDropout", dropout_ratio=0.2, dropout_application_ratio=0.2),
    # dict(type="RandomRotateTargetAngle", angle=(1/2, 1, 3/2), center=[0, 0, 0], axis="z", p=0.75),
    dict(type="RandomRotate", angle=[-1, 1], axis="z", center=[0, 0, 0], p=0.5),
    dict(type="RandomRotate", angle=[-1 / 64, 1 / 64], axis="x", p=0.5),
    dict(type="RandomRotate", angle=[-1 / 64, 1 / 64], axis="y", p=0.5),
    dict(type="RandomScale", scale=[0.9, 1.1]),
    # dict(type="RandomShift", shift=[0.2, 0.2, 0.2]),
    dict(type="RandomFlip", p=0.5),
    dict(type="RandomJitter", sigma=0.005, clip=0.02),
    dict(type="ElasticDistortion", distortion_params=[[0.2, 0.4], [0.8, 1.6]]),
    dict(type="ChromaticAutoContrast", p=0.2, blend_factor=None),
    dict(type="ChromaticTranslation", p=0.95, ratio=0.05),
    dict(type="ChromaticJitter", p=0.95, std=0.05),
    # dict(type="HueSaturationTranslation", hue_max=0.2, saturation_max=0.2),
    # dict(type="RandomColorDrop", p=0.2, color_augment=0.0),
    dict(
        type="GridSample",
        grid_size=0.02,
        hash_type="fnv",
        mode="train",
        return_grid_coord=True,
    ),
    dict(type="SphereCrop", point_max=65536, mode="given"),
    # dict(type="SphereCrop", point_max=102400, mode="given"),
    dict(type="CenterShift", apply_z=False),
    dict(type="NormalizeColor"),
    # dict(type="ShufflePoint"),
    dict(type="ToTensor"),
    dict(
        type="Collect",
        keys=(
            "coord",
            "color",
            "normal",
            "grid_coord",
            "segment",
            "imgs",
            "mask_index",
            "img_num",
            "name",
        ),
        feat_keys=("coord", "color", "normal"),
    ),
]


# dataset settings
dataset_type = "ScanNetDataset"
data_root = "data/scannet"
data = dict(
    num_classes=20,
    ignore_index=-1,
    names=[
        "wall",
        "floor",
        "cabinet",
        "bed",
        "chair",
        "sofa",
        "table",
        "door",
        "window",
        "bookshelf",
        "picture",
        "counter",
        "desk",
        "curtain",
        "refridgerator",
        "shower curtain",
        "toilet",
        "sink",
        "bathtub",
        "otherfurniture",
    ],
    train=dict(
        type="ConcatDataset",
        datasets=[
            # arkit
            dict(
                # type="Dust3rDINOScanNetPPDataset",
                type="ScanNetPPDatasetALL_img",
                # type="ScanNetDataset",
                crop_h=crop_h,
                crop_w=crop_w,
                patch_size=patch_size,
                split=["train", "val", "test"],
                # data_root="data/scannetpp_processed_all_split/scene",
                # data_root="/high_perf_store3/l3_data/xxx/datasets/ar_img",
                data_root="/high_perf_store3/l3_data/xxx/datasets/arkit_img_compressed/arkitscenes_trans_all_split",
                # data_root="data/scannet",
                transform=transform,
                test_mode=False,
                loop=1,
            ),
            # ScanNet 1,613
            dict(
                # type="Dust3rDINOScanNetPPDataset",
                type="ScanNetPPDatasetALL_img",
                # type="ScanNetDataset",
                crop_h=crop_h,
                crop_w=crop_w,
                patch_size=patch_size,
                split=["train"],
                data_root="/high_perf_store3/l3_data/xxx/datasets/sc_img_3",
                # data_root="/high_perf_store3/l3_data/xxx/datasets/sc_img_2",
                # data_root="data/scannet",
                transform=transform,
                test_mode=False,
                loop=1,
            ),
            # ScanNet++ 1,016
            dict(
                type="ScanNetPPDatasetALL_img",
                # type="ScanNetPPDataset",
                crop_h=crop_h,
                crop_w=crop_w,
                patch_size=patch_size,
                split=[
                    "train",
                    "val",
                    "test",
                ],
                data_root="/high_perf_store3/l3_data/xxx/datasets/scppv2_img/scppv2_img",
                # data_root="data/scannetpp",
                transform=transform,
                test_mode=False,
                loop=1,
            ),
            # S3DIS 272
            dict(
                type="S3DISDatasetALL_img",
                crop_h=crop_h,
                crop_w=crop_w,
                patch_size=patch_size,
                split=["train"],
                # split=["Area_1", "Area_2", "Area_3", "Area_4", "Area_5", "Area_6"],
                data_root="/high_perf_store3/l3_data/xxx/datasets/s3dis_origin/s3dis_preprocessed_split",
                transform=transform,
                test_mode=False,
                loop=1,
            ),
            # HM3D 11,493
            dict(
                type="RE10KDatasetALL_img",
                crop_h=crop_h,
                crop_w=crop_w,
                patch_size=patch_size,
                split=["train", "val"],
                data_root="/high_perf_store3/l3_data/xxx/datasets/hm3d_img/hm3d_preprocessed",
                transform=transform,
                test_mode=False,
                # force_label=False,
                loop=1,
            ),
            # Structured3D 21,821
            dict(
                # type="Structured3DDataset",
                type="Structured3DDatasetALL_img",
                crop_h=crop_h,
                crop_w=crop_w,
                patch_size=patch_size,
                split=["train", "val", "test"],
                # data_root="data/structured3d",
                data_root="/high_perf_store3/l3_data/xxx/datasets/st3d_img/st3d_img",
                transform=transform,
                test_mode=False,
                loop=1,
            ),
            # # RE10K 89.976
            # dict(
            #     type="RE10KDatasetALL_img",
            #     crop_h = crop_h,
            #     crop_w = crop_w,
            #     patch_size = patch_size,
            #     split=["train", "val"],
            #     data_root="/high_perf_store3/l3_data/xxx/datasets/re10k_img_all",
            #     transform=transform,
            #     test_mode=False,
            #     loop=1,
            # ),
        ],
    ),
    val=dict(
        type=dataset_type,
        split="val",
        data_root=data_root,
        transform=[
            dict(type="CenterShift", apply_z=True),
            dict(type="Copy", keys_dict={"segment": "origin_segment"}),
            dict(
                type="GridSample",
                grid_size=0.02,
                hash_type="fnv",
                mode="train",
                return_grid_coord=True,
                return_inverse=True,
            ),
            dict(type="CenterShift", apply_z=False),
            dict(type="NormalizeColor"),
            dict(type="ToTensor"),
            dict(
                type="Collect",
                keys=("coord", "grid_coord", "segment", "origin_segment", "inverse"),
                feat_keys=("coord", "color", "normal"),
            ),
        ],
        test_mode=False,
    ),
    test=dict(
        type=dataset_type,
        split="val",
        data_root=data_root,
        transform=[
            dict(type="CenterShift", apply_z=True),
            dict(type="NormalizeColor"),
        ],
        test_mode=True,
        test_cfg=dict(
            voxelize=dict(
                type="GridSample",
                grid_size=0.02,
                hash_type="fnv",
                mode="test",
                keys=("coord", "color", "normal"),
                return_grid_coord=True,
            ),
            crop=None,
            post_transform=[
                dict(type="CenterShift", apply_z=False),
                dict(type="ToTensor"),
                dict(
                    type="Collect",
                    keys=("coord", "grid_coord", "index"),
                    feat_keys=("coord", "color", "normal"),
                ),
            ],
            aug_transform=[
                [
                    dict(
                        type="RandomRotateTargetAngle",
                        angle=[0],
                        axis="z",
                        center=[0, 0, 0],
                        p=1,
                    )
                ],
                [
                    dict(
                        type="RandomRotateTargetAngle",
                        angle=[1 / 2],
                        axis="z",
                        center=[0, 0, 0],
                        p=1,
                    )
                ],
                [
                    dict(
                        type="RandomRotateTargetAngle",
                        angle=[1],
                        axis="z",
                        center=[0, 0, 0],
                        p=1,
                    )
                ],
                [
                    dict(
                        type="RandomRotateTargetAngle",
                        angle=[3 / 2],
                        axis="z",
                        center=[0, 0, 0],
                        p=1,
                    )
                ],
                [
                    dict(
                        type="RandomRotateTargetAngle",
                        angle=[0],
                        axis="z",
                        center=[0, 0, 0],
                        p=1,
                    ),
                    dict(type="RandomScale", scale=[0.95, 0.95]),
                ],
                [
                    dict(
                        type="RandomRotateTargetAngle",
                        angle=[1 / 2],
                        axis="z",
                        center=[0, 0, 0],
                        p=1,
                    ),
                    dict(type="RandomScale", scale=[0.95, 0.95]),
                ],
                [
                    dict(
                        type="RandomRotateTargetAngle",
                        angle=[1],
                        axis="z",
                        center=[0, 0, 0],
                        p=1,
                    ),
                    dict(type="RandomScale", scale=[0.95, 0.95]),
                ],
                [
                    dict(
                        type="RandomRotateTargetAngle",
                        angle=[3 / 2],
                        axis="z",
                        center=[0, 0, 0],
                        p=1,
                    ),
                    dict(type="RandomScale", scale=[0.95, 0.95]),
                ],
                [
                    dict(
                        type="RandomRotateTargetAngle",
                        angle=[0],
                        axis="z",
                        center=[0, 0, 0],
                        p=1,
                    ),
                    dict(type="RandomScale", scale=[1.05, 1.05]),
                ],
                [
                    dict(
                        type="RandomRotateTargetAngle",
                        angle=[1 / 2],
                        axis="z",
                        center=[0, 0, 0],
                        p=1,
                    ),
                    dict(type="RandomScale", scale=[1.05, 1.05]),
                ],
                [
                    dict(
                        type="RandomRotateTargetAngle",
                        angle=[1],
                        axis="z",
                        center=[0, 0, 0],
                        p=1,
                    ),
                    dict(type="RandomScale", scale=[1.05, 1.05]),
                ],
                [
                    dict(
                        type="RandomRotateTargetAngle",
                        angle=[3 / 2],
                        axis="z",
                        center=[0, 0, 0],
                        p=1,
                    ),
                    dict(type="RandomScale", scale=[1.05, 1.05]),
                ],
                [dict(type="RandomFlip", p=1)],
            ],
        ),
    ),
)

hooks = [
    dict(
        type="CheckpointLoader",
        keywords="module.student.backbone",
        replacement="module.backbone",
    ),
    dict(type="ModelHook"),
    # dict(type="WeightDecaySchedular", base_value=base_wd, final_value=final_wd),
    dict(type="IterationTimer", warmup_iter=2),
    dict(type="InformationWriter"),
    dict(type="SemSegEvaluator"),
    dict(type="CheckpointSaver", save_freq=10),
    dict(type="PreciseEvaluator", test_last=False),
]
