import numpy as np

obs_mean_dict = {
    'halfcheetah-expert-v2': np.array([-0.0448938 ,  0.03229331,  0.06037571, -0.17081636, -0.19480342,
                                        -0.05755221,  0.09699936,  0.03238247, 11.04674   , -0.08001192,
                                        -0.3236391 ,  0.3636905 ,  0.42418915,  0.408233  ,  1.1076112 ,
                                        -0.48774815, -0.07378904], dtype=np.float32),
    'walker2d-expert-v2': np.array([ 1.23850238e+00,  1.95760176e-01, -1.04799464e-01, -1.85960338e-01,
                                        2.29559347e-01,  2.27993485e-02, -3.73786807e-01,  3.38166147e-01,
                                        3.92461300e+00, -4.83204611e-03,  2.51609739e-02, -5.04571013e-03,
                                        -1.72384977e-02, -4.81454253e-01,  4.88845399e-04, -7.19817239e-04,
                                        3.51484329e-03], dtype=np.float32),
    'hopper-expert-v2': np.array([ 1.348851  , -0.11204933, -0.55070853, -0.13163613, -0.0031308 ,
                                    2.6067436 ,  0.02230332, -0.0165702 , -0.06813174, -0.05349138,
                                    0.04012826], dtype=np.float32),

    'halfcheetah-medium-v2': np.array([-0.06845334,  0.01638909, -0.18353942, -0.27623472, -0.34062243,
                                        -0.09342235, -0.21320896, -0.08775322,  5.1728888 , -0.0427519 ,
                                        -0.03614707,  0.14031197,  0.06066204,  0.09548277,  0.06728936,
                                        0.00586709,  0.0136218 ], dtype=np.float32),
    'walker2d-medium-v2': np.array([ 1.2189686 ,  0.14164123, -0.03705529, -0.13813919,  0.5138941 ,
                                        -0.04718518, -0.47281957,  0.04226833,  2.394622  , -0.03145574,
                                        0.04461097, -0.0240107 , -0.10130639,  0.09077299, -0.00420647,
                                        -0.1214322 , -0.54976344], dtype=np.float32),
    'hopper-medium-v2': np.array([ 1.3112686 , -0.08469262, -0.53825426, -0.07201052,  0.04934485,
                                        2.106582  , -0.15014714,  0.00878511, -0.28485158, -0.18539158,
                                        -0.28468254], dtype=np.float32),
    
    'halfcheetah-medium-expert-v2': np.array([-0.05667356,  0.02434099, -0.0616518 , -0.2235114 , -0.2675142 ,
                                            -0.07548794, -0.05810355, -0.02768525,  8.11021   , -0.06138258,
                                            -0.1798906 ,  0.2519955 ,  0.2424271 ,  0.25185725,  0.58744943,
                                            -0.24094017, -0.03008529], dtype=np.float32),
    'walker2d-medium-expert-v2':np.array([ 1.22944760e+00,  1.68695122e-01, -7.09261745e-02, -1.62060216e-01,
                                            3.70787919e-01, -1.21987425e-02, -4.24544632e-01,  1.90094694e-01,
                                            3.16228247e+00, -1.81453414e-02,  3.48955616e-02, -1.45223942e-02,
                                            -5.92759401e-02, -1.95304289e-01, -1.85440504e-03, -6.10819161e-02,
                                            -2.73194641e-01], dtype=np.float32),
    'hopper-medium-expert-v2': np.array([ 1.3293043 , -0.09834603, -0.5444588 , -0.10188299,  0.02310903,
                                            2.3574705 , -0.06397343, -0.00388843, -0.17651455, -0.1194735 ,
                                            -0.12231296], dtype=np.float32),
    
    'halfcheetah-medium-replay-v2': np.array([-0.12877479,  0.37359434, -0.14996345, -0.23483111, -0.2841602 ,
                                                -0.13100752, -0.20162779, -0.06519801,  3.4770117 , -0.02784209,
                                                -0.01490434,  0.07666185,  0.01264528,  0.02752821,  0.02370907,
                                                0.00993407, -0.01593382], dtype=np.float32),
    'walker2d-medium-replay-v2': np.array([ 1.209357  ,  0.13263011, -0.14372443, -0.20466831,  0.5577756 ,
                                            -0.03231523, -0.2784598 ,  0.19131525,  1.4699975 , -0.12507579,
                                            0.05637845, -0.10007039, -0.34002182,  0.03530184, -0.08931354,
                                            -0.2996404 , -0.598099  ], dtype=np.float32) ,
    'hopper-medium-replay-v2': np.array([ 1.2305259 , -0.04371495, -0.4454177 , -0.09368918,  0.09094568,
                                            1.369416  , -0.19986361, -0.02282764, -0.5286929 , -0.14456923,
                                            -0.19641861], dtype=np.float32),
    
    'halfcheetah-random-v2': np.array([-0.156536  ,  0.666053  ,  0.00278496,  0.01825556, -0.00304491,
                                            0.03655876, -0.02007798, -0.02045568, -0.09163511, -0.0139697 ,
                                            0.01134165,  0.02190039, -0.06033378,  0.03174863,  0.00570832,
                                            0.03916975,  0.00746564], dtype=np.float32) ,
    'walker2d-random-v2': np.array([ 1.2004834 , -0.35097116, -0.21856245, -0.3024979 ,  0.25761455,
                                            -0.22022863, -0.29657584,  0.25247023, -0.8834828 , -0.94912714,
                                            -4.8009095 , -3.068046  , -3.1100168 ,  1.2372769 , -3.075624  ,
                                            -3.0704749 ,  1.1947048 ], dtype=np.float32),
    'hopper-random-v2': np.array([ 1.2273494 , -0.06166753, -0.043392  , -0.06191828,  0.04466476,
                                            -0.1557904 , -0.24393883, -1.1188294 , -0.7780452 , -0.8612563 ,
                                            0.45711017], dtype=np.float32),

    'hammer-expert-v1': np.array([ 0.028962  , -0.21877854, -0.07000254, -0.42764446, -0.00664428,
                            0.8553341 ,  0.7411036 ,  0.8073038 ,  0.08316178,  0.96588945,
                            0.7238345 ,  0.7738554 , -0.08472217,  0.54297477,  1.1733835 ,
                            1.2671515 ,  0.12945656, -0.24652928,  1.0616271 ,  0.97317463,
                            1.0899075 ,  0.14589007,  1.0909173 ,  0.21370286, -0.2552807 ,
                            -0.3377061 ,  0.05915479,  0.01573809,  0.07722777, -0.00618173,
                            0.10312278, -0.0215991 ,  0.0633475 ,  0.11226971, -0.20915876,
                            0.17147635,  0.08721221, -0.19282743,  0.1706822 ,  2.0008337 ,
                            -0.44847977,  0.24271807,  0.01077317, -0.01515449,  0.17477676,
                            0.02375079], dtype=np.float32),
    'hammer-cloned-v1': np.array([ 0.10196251, -0.0796454 , -0.00608807, -0.10339415,  0.06555021,
                                0.6972843 ,  0.49984357,  0.49435273,  0.08197109,  0.56060845,
                                0.5816923 ,  0.60589015, -0.09468812,  0.34748128,  0.80115163,
                                0.8682147 ,  0.10523399, -0.25975558,  0.65095264,  0.6579514 ,
                                0.67311174, -0.12288884,  0.7820633 ,  0.18434542, -0.2705551 ,
                                -0.43236408,  0.01618431, -0.01672713,  0.00529001, -0.0083526 ,
                                -0.00201397,  0.01384516,  0.01100413,  0.03475956, -0.21533619,
                                0.11030642,  0.0177573 , -0.19407406,  0.0739535 ,  1.6491715 ,
                                -0.15654054,  0.07088208, -0.02926288, -0.03076176,  0.17689678,
                                0.02583896], dtype=np.float32),
    'hammer-huamn-v1': np.array([ 8.91164094e-02, -1.29111364e-01, -4.54010740e-02, -1.95215791e-01,
                                -1.28944032e-02,  8.11014354e-01,  7.21180439e-01,  7.17338383e-01,
                                4.87673879e-02,  8.23352456e-01,  7.59211421e-01,  8.18735480e-01,
                                -1.02867045e-01,  4.94659901e-01,  1.04719901e+00,  1.17471051e+00,
                                8.06916133e-02, -2.63025582e-01,  8.88187528e-01,  8.21335852e-01,
                                8.54645371e-01, -5.08411489e-02,  9.54019964e-01,  2.00983271e-01,
                                -2.88090467e-01, -5.51663876e-01,  3.20326015e-02, -1.79308522e-02,
                                1.20593449e-02, -5.94846299e-03, -1.32208830e-02,  2.73830518e-02,
                                -1.39935664e-03,  6.40103146e-02, -2.11678833e-01,  1.22384138e-01,
                                4.91850749e-02, -1.97386101e-01,  1.16322830e-01,  1.71258724e+00,
                                -3.01306129e-01,  1.05370745e-01, -1.43066067e-02, -2.49996763e-02,
                                1.77903280e-01,  5.08334041e-02], dtype=np.float32),
    'pen-expert-v1': np.array([-1.00193314e-01, -4.30588484e-01,  1.65265441e-01,  7.43016958e-01,
                                8.43255639e-01,  8.59054804e-01,  5.55766709e-02,  7.76941776e-01,
                                7.68743038e-01,  9.69423771e-01, -1.35850310e-01,  5.05703986e-01,
                                1.10327923e+00,  1.17032361e+00,  2.83481777e-01,  1.50796911e-03,
                                1.44471681e+00,  9.47286189e-01,  9.96446431e-01,  1.96997911e-01,
                                9.08621550e-01, -4.56883088e-02, -9.47577730e-02, -6.38459623e-02,
                                1.99432857e-03, -2.00560167e-01,  2.34287977e-01,  1.01033263e-02,
                                -1.63944415e-03,  6.17993018e-03, -1.82621747e-01, -7.63052404e-01,
                                -2.11762205e-01,  3.64301205e-01,  4.32600379e-02,  5.30860484e-01,
                                3.42490268e-03,  1.96190248e-03,  7.01808989e-01,  1.99432857e-03,
                                -4.87884769e-04, -1.57212969e-02,  3.60863149e-01,  4.12985086e-02,
                                -1.70777604e-01], dtype=np.float32),
    'pen-human-v1': np.array([-2.0780860e-01, -6.8544036e-01, -2.3311156e-01,  1.3716350e+00,
                                4.0895575e-01,  4.8143607e-01, -1.8088886e-01,  1.1274990e+00,
                                6.6655880e-01,  6.9234526e-01, -2.0327985e-01,  8.1739628e-01,
                                1.7237727e-01,  2.0913926e-01,  4.3442103e-01, -1.5731150e-01,
                                1.4512514e+00,  1.2936040e+00,  1.4080030e+00, -4.0947142e-01,
                                8.5158068e-01,  1.1716819e-01, -3.6440679e-01, -8.1422067e-01,
                                -2.7861248e-03, -2.0161290e-01,  2.1377479e-01,  1.8639890e-02,
                                -1.2093167e-03, -1.3380526e-03, -1.2723778e-03, -4.4995984e-01,
                                -5.0755125e-01,  3.1238598e-01, -1.0563735e-02,  6.7901826e-01,
                                7.7132814e-02, -3.4477592e-02,  6.9334346e-01, -2.7861248e-03,
                                -1.6128281e-03, -3.6224242e-02,  2.3525199e-01,  2.3913439e-02,
                                -1.4324171e-02], dtype=np.float32),
    'pen-cloned-v1': np.array([-2.26479277e-01, -6.73103869e-01, -1.83567643e-01,  1.28851759e+00,
                                3.96048754e-01,  4.74666804e-01, -1.73889503e-01,  1.00268793e+00,
                                6.38734937e-01,  6.56460643e-01, -2.28156596e-01,  7.64367223e-01,
                                1.34836674e-01,  1.59146562e-01,  4.17277753e-01, -1.71355188e-01,
                                1.42499447e+00,  1.25546420e+00,  1.35944664e+00, -3.98854762e-01,
                                7.94661701e-01,  1.18858755e-01, -2.93653250e-01, -7.66643226e-01,
                                -2.98969098e-03, -2.01114953e-01,  2.14483589e-01,  2.82732565e-02,
                                -1.68465881e-03, -2.18736054e-03, -1.42785579e-01, -6.90549731e-01,
                                -8.18207264e-01,  3.74786824e-01,  1.64556541e-02,  6.35416448e-01,
                                3.74727920e-02, -2.15777382e-02,  6.98001027e-01, -2.98969098e-03,
                                -9.96185117e-04, -3.55971530e-02,  3.37219238e-01,  3.80518176e-02,
                                -6.27757683e-02], dtype=np.float32),
    'door-expert-v1': np.array([-1.1748426e-03, -5.4486066e-01,  1.0073318e+00,  9.6592255e-02,
                                -1.4078362e-01,  3.1765193e-02,  6.3582069e-01,  2.3832051e-01,
                                2.2269917e-01,  1.2774141e-01,  4.3564159e-01,  3.0790135e-01,
                                2.7244055e-01, -1.8357104e-02,  4.4840223e-01,  3.5652906e-01,
                                3.4300730e-01,  9.0589851e-02, -1.3595256e-01,  3.0892327e-01,
                                4.2767972e-01,  3.9676353e-01,  7.5822167e-02,  9.4932950e-01,
                                1.9073938e-01, -3.5211954e-01, -4.9710509e-01,  1.4216534e+00,
                                1.1512899e+00,  2.2103068e-01, -2.4365382e-01,  2.0007072e-01,
                                3.5022953e-01, -1.1218394e-01,  1.4888631e-01, -1.2918094e-01,
                                -1.3143593e-01,  5.1134925e-02,  4.7813669e-01], dtype=np.float32),
    'door-cloned-v1': np.array([-0.09418432, -0.39932168,  0.00669657,  0.05374736, -0.18767254,
                                0.10309252,  0.6377681 ,  0.18832172,  0.17815493,  0.10472859,
                                0.47225422,  0.27352306,  0.24451816, -0.07393912,  0.24722292,
                                0.32348302,  0.3514679 ,  0.12221804, -0.22894098,  0.24030909,
                                0.29168728,  0.28108457,  0.03333369,  0.819618  ,  0.14525802,
                                -0.30269766, -0.36820418,  0.5252245 ,  0.19304678,  0.17760168,
                                -0.13412622,  0.21121673,  0.08861312,  0.09148438,  0.23880093,
                                0.08904896, -0.22554263, -0.02765558, -0.7687442 ], dtype=np.float32),
    'door-human-v1': np.array([-0.038452  , -0.19731632,  0.73727655,  0.03168287, -0.24779627,
                                -0.01474202,  0.66239476,  0.3538519 ,  0.33412552,  0.0653267 ,
                                0.5931598 ,  0.47358832,  0.43627375, -0.04256765,  0.3869481 ,
                                0.57924026,  0.6193181 ,  0.10954889, -0.16507083,  0.39961374,
                                0.4810469 ,  0.48171535,  0.2270577 ,  0.98654675,  0.1916613 ,
                                -0.3027063 , -0.5258982 ,  1.0459445 ,  0.37398288,  0.07070972,
                                -0.05146757,  0.20441237,  0.13565655,  0.03566417,  0.20259795,
                                -0.06494608, -0.08713161,  0.00181493, -0.53699285], dtype=np.float32),

    'antmaze-umaze-v0': np.array([ 3.99915791e+00,  7.04570103e+00,  4.90256101e-01,  6.31233096e-01,
                                -2.02854387e-02,  1.24581382e-01, -1.79474309e-01,  3.65794338e-02,
                                7.08480537e-01,  6.16301298e-02, -7.75101781e-01, -1.12418860e-01,
                                -6.98007166e-01,  3.10411900e-02,  7.37621009e-01,  4.22246382e-02,
                                1.17463209e-01, -6.26264606e-04, -5.35578188e-03,  1.95646333e-03,
                                -1.36725027e-02, -2.45138537e-03,  1.65952779e-02, -2.39802641e-03,
                                -1.56408790e-02,  1.50362414e-03, -1.64172966e-02,  6.59396127e-03,
                                1.54006565e-02], dtype=np.float32),
    'antmaze-umaze-diverse-v0': np.array([ 3.0329816e+00,  8.3090487e+00,  4.6599537e-01,  5.7715428e-01,
                                1.6173447e-02,  1.4234918e-01, -1.5609261e-01,  6.0852714e-02,
                                6.9999897e-01,  7.9136617e-02, -8.0440551e-01, -1.4198084e-01,
                                -6.9159895e-01,  4.8371054e-02,  7.2507775e-01, -3.3101656e-02,
                                4.7257673e-02,  6.5111945e-04, -5.2789756e-04,  3.4066522e-03,
                                -8.0543142e-03, -4.7186916e-03,  1.1968394e-02,  2.9152716e-03,
                                -1.1976988e-02,  9.5337408e-04, -1.4754672e-02,  4.9922275e-03,
                                1.4129263e-02], dtype=np.float32),
    'antmaze-medium-play-v0': np.array([ 1.21584778e+01,  1.30394249e+01,  4.81851429e-01,  5.17338693e-01,
                                2.59458907e-02,  3.66587229e-02,  6.14472441e-02, -3.12156770e-02,
                                6.85948014e-01,  1.16689980e-01, -7.04927206e-01, -4.80984971e-02,
                                -7.78080225e-01,  1.33605776e-02,  6.98680758e-01,  2.15526912e-02,
                                3.06501817e-02,  6.87048712e-04,  2.90040416e-03,  1.18960824e-03,
                                2.19414267e-03, -3.52865376e-04,  1.14899445e-02, -1.97296613e-05,
                                -1.19303651e-02, -3.01822764e-03, -1.20287547e-02,  4.29906277e-03,
                                1.20056383e-02], dtype=np.float32),
    'antmaze-medium-diverse-v0': np.array([ 1.20011148e+01,  1.29060955e+01,  4.84394789e-01,  5.40185213e-01,
                                1.95419788e-02,  3.17402892e-02,  9.08239037e-02, -2.74106022e-02,
                                6.83755636e-01,  1.07476152e-01, -7.04956055e-01, -4.88677435e-02,
                                -7.85227120e-01,  1.43614626e-02,  6.90329969e-01,  2.80840378e-02,
                                3.33367772e-02,  3.38851212e-04,  2.22742301e-03,  6.72019014e-05,
                                2.19628564e-03, -2.61553650e-04,  1.18056452e-02,  1.74346103e-04,
                                -1.19921155e-02, -3.75007303e-03, -1.24019077e-02,  4.57204739e-03,
                                1.24904159e-02], dtype=np.float32),
    'antmaze-large-play-v0': np.array([ 2.00286179e+01,  1.36249895e+01,  4.76995260e-01,  5.20501971e-01,
                                1.28580090e-02,  3.51782888e-02,  5.91137148e-02, -5.45489863e-02,
                                6.89068377e-01,  1.09376356e-01, -7.13929176e-01, -7.03197643e-02,
                                -7.47348845e-01,  7.28889741e-03,  7.11534142e-01,  1.34588238e-02,
                                3.40029299e-02,  6.36690180e-04,  6.87875727e-04, -7.46800564e-04,
                                -5.78802370e-04,  1.02579617e-03,  1.22042596e-02, -5.56261395e-04,
                                -1.24679450e-02, -2.56247330e-03, -1.09799141e-02,  4.37899120e-03,
                                1.17060505e-02], dtype=np.float32),
    'antmaze-large-diverse-v0': np.array([ 1.9880697e+01,  1.3796340e+01,  4.8059732e-01,  5.3231460e-01,
                                2.7669142e-03,  5.9847958e-02,  4.9519677e-02, -5.0313000e-02,
                                6.8979847e-01,  9.9476218e-02, -7.1115810e-01, -6.2134948e-02,
                                -7.4911869e-01,  9.4330302e-03,  7.1103793e-01,  2.4053441e-02,
                                3.3879742e-02,  6.1636441e-04,  8.1653282e-04, -1.9637516e-04,
                                1.1082720e-05,  8.1450364e-04,  1.2339019e-02,  3.5862031e-04,
                                -1.2303633e-02, -2.7672099e-03, -1.1466572e-02,  3.8100607e-03,
                                1.1843752e-02], dtype=np.float32),
    'relocate-expert-v1':np.array([-0.01877487,  0.00952405,  0.18584377, -0.10023135, -0.02176104,
                                0.11173039,  0.06928866,  0.02361079,  0.18108831,  0.56431633,
                                0.6820411 ,  0.83365214,  0.11072525,  0.36556894,  0.7219847 ,
                                0.7095855 , -0.1516057 ,  0.2592909 ,  0.9575345 ,  1.0248742 ,
                                0.3833286 , -0.3449266 ,  0.59702545,  1.0392826 ,  1.0356295 ,
                                0.17632207,  0.98821384,  0.127567  , -0.05265519, -0.3925386 ,
                                0.00596324, -0.04877128,  0.01460047,  0.00860364, -0.02502023,
                                -0.04119283,  0.00264034,  0.02374645, -0.05579721], dtype=np.float32),
    'relocate-cloned-v1': np.array([-0.03960345,  0.01820108,  0.1364413 ,  0.01453378, -0.09649565,
                                0.18785158,  0.0765456 ,  0.03211457,  0.10898696,  0.72715276,
                                0.47347373,  0.45792973,  0.12396149,  0.47233602,  0.5020171 ,
                                0.46304175, -0.08362247,  0.28323588,  0.73350334,  0.77729756,
                                0.36998278, -0.3182292 ,  0.47834203,  0.89951557,  0.89207214,
                                0.06707308,  0.8325045 ,  0.14675085, -0.25504184, -0.32124472,
                                0.04503255, -0.19907823,  0.10016279,  0.06843244, -0.10860524,
                                -0.04251039,  0.02341787,  0.0904505 , -0.14252248], dtype=np.float32),
    'relocate-human-v1': np.array([-0.07946289,  0.0094875 ,  0.22002275, -0.00128837,  0.06866115,
                                0.10871706,  0.07172822,  0.00838126,  0.12164855,  0.68968767,
                                0.45595825,  0.42687577,  0.13113216,  0.42879593,  0.46495995,
                                0.40046763, -0.09510819,  0.3059029 ,  0.68665504,  0.7300644 ,
                                0.30128852, -0.36939502,  0.40610743,  0.828933  ,  0.8046271 ,
                                -0.06632449,  0.78295994,  0.12741242, -0.18335856, -0.2812059 ,
                                0.00218195, -0.05264918,  0.04950697,  0.03935849,  0.04463812,
                                -0.0168125 ,  0.0371767 ,  0.09728648, -0.06631905], dtype=np.float32)
}

obs_std_dict = {
    'halfcheetah-expert-v2': np.array([ 0.0400122 ,  0.41047668,  0.5421747 ,  0.41522014,  0.23796107,
                                        0.62038046,  0.30099928,  0.21737091,  2.2112684 ,  0.57260793,
                                        1.7255459 , 11.843713  , 12.062452  ,  7.0495715 , 13.499574  ,
                                        7.1951504 ,  5.0263114 ], dtype=np.float32),
    'walker2d-expert-v2': np.array([0.06667095, 0.16991   , 0.1731311 , 0.2184564 , 0.7460793 ,
                                        0.02410412, 0.3730244 , 0.6224817 , 0.9712348 , 0.72944593,
                                        1.5042623 , 2.4953601 , 3.5120149 , 5.366501  , 0.7951459 ,
                                        4.3164725 , 6.177178  ], dtype=np.float32),
    'hopper-expert-v2': np.array([0.15980658, 0.04461683, 0.14312272, 0.176148  , 0.59111804,
                                        0.5901703 , 1.5408131 , 0.8154756 , 2.0179563 , 2.4103951 ,
                                        5.8460703 ], dtype=np.float32),

    'halfcheetah-medium-v2': np.array([ 0.07472187,  0.3022498 ,  0.30206135,  0.34415913,  0.17618905,
                                        0.5071963 ,  0.25669125,  0.32947835,  1.2575423 ,  0.7600313 ,
                                        1.9801235 ,  6.565428  ,  7.466306  ,  4.472146  , 10.567045  ,
                                        5.6718545 ,  7.498177  ], dtype=np.float32),
    'walker2d-medium-v2': np.array([0.12310076, 0.32416815, 0.11456984, 0.2623033 , 0.5639767 ,
                                        0.22717912, 0.38371265, 0.7373489 , 1.2387735 , 0.7979946 ,
                                        1.5667049 , 1.809477  , 3.025654  , 4.0624304 , 1.4590031 ,
                                        3.7444007 , 5.5849957 ], dtype=np.float32),
    'hopper-medium-v2': np.array([0.17790356, 0.05444648, 0.2129813 , 0.14529777, 0.61242145,
                                        0.8517834 , 1.4514914 , 0.675177  , 1.5362306 , 1.6160218 ,
                                        5.6071143 ], dtype=np.float32),
    
    'halfcheetah-medium-expert-v2': np.array([ 0.06102667,  0.36032283,  0.45544082,  0.38475862,  0.22183323,
                                                0.566753  ,  0.319655  ,  0.28529158,  3.4438038 ,  0.6728104 ,
                                                1.861734  ,  9.575525  , 10.029394  ,  5.9034157 , 12.128048  ,
                                                6.48088   ,  6.3785396 ], dtype=np.float32),
    'walker2d-medium-expert-v2':np.array([0.09932247, 0.25981924, 0.15066291, 0.24249935, 0.67597985,
                                            0.1650479 , 0.38141313, 0.6962343 , 1.3502052 , 0.76421404,
                                            1.5348006 , 2.178446  , 3.276931  , 4.7667336 , 1.171848  ,
                                            4.0392075 , 5.8909817 ], dtype=np.float32),
    'hopper-medium-expert-v2': np.array([0.17011586, 0.0515848 , 0.18143974, 0.16420476, 0.6022738 ,
                                            0.77375716, 1.4987783 , 0.7484332 , 1.7956114 , 2.0526369 ,
                                            5.7260118 ], dtype=np.float32),
    
    'halfcheetah-medium-replay-v2': np.array([0.17016725, 1.284131  , 0.3344234 , 0.3672746 , 0.2608973 ,
                                                0.47840405, 0.31813785, 0.3355286 , 2.0930293 , 0.803701  ,
                                                1.9043621 , 6.572885  , 7.572577  , 5.0694695 , 9.104927  ,
                                                6.0853467 , 7.253169  ], dtype=np.float32),
    'walker2d-medium-replay-v2': np.array([0.11930003, 0.35626867, 0.25851834, 0.42080614, 0.5202125 ,
                                                0.15687291, 0.3677264 , 0.71613055, 1.376339  , 0.86328906,
                                                2.636631  , 3.013588  , 3.7210872 , 4.867173  , 2.668249  ,
                                                3.845076  , 5.4770126 ], dtype=np.float32) ,
    'hopper-medium-replay-v2': np.array([0.175637  , 0.06369085, 0.34381446, 0.19564126, 0.55479336,
                                                1.0510002 , 1.1582516 , 0.79631305, 1.4800673 , 1.6538364 ,
                                                5.1085076 ], dtype=np.float32),
    
    'halfcheetah-random-v2': np.array([0.18690161, 1.2158394 , 0.2575045 , 0.2754539 , 0.26605174,
                                            0.3315526 , 0.3077289 , 0.28535482, 0.72353065, 0.7387111 ,
                                            1.5437698 , 5.667969  , 6.843043  , 7.042959  , 6.4058084 ,
                                            6.7340183 , 6.076451  ], dtype=np.float32) ,
    'walker2d-random-v2': np.array([0.05937485, 0.30282995, 0.27900195, 0.42349848, 0.4044611 ,
                                            0.2796131 , 0.41917005, 0.4077238 , 0.583644  , 0.9854787 ,
                                            4.702651  , 5.9798326 , 5.308321  , 7.41063   , 5.982481  ,
                                            5.302595  , 7.396656  ], dtype=np.float32) ,
    'hopper-random-v2': np.array([0.02483105, 0.06347698, 0.06574889, 0.1009838 , 0.15176307,
                                            0.41154876, 0.29898068, 1.3966098 , 1.4490739 , 1.4826245 ,
                                            1.7376856 ], dtype=np.float32) ,
    
    'hammer-expert-v1': np.array([0.06067558, 0.10977114, 0.10799917, 0.3412792 , 0.05921056,
                            0.16250807, 0.2262941 , 0.23053077, 0.05806333, 0.28362313,
                            0.19187056, 0.20010233, 0.04478291, 0.19642466, 0.32374623,
                            0.3362134 , 0.09397668, 0.08335996, 0.3186349 , 0.3010364 ,
                            0.32702437, 0.13816194, 0.21446112, 0.05275438, 0.06727637,
                            0.168661  , 0.03371396, 0.38898593, 0.34350714, 0.11550818,
                            0.69120556, 0.6962102 , 0.6148566 , 0.06416199, 0.00934207,
                            0.05020712, 0.07149724, 0.01823657, 0.07067004, 0.27555838,
                            0.23719779, 0.13176702, 0.0314211 , 0.01225049, 0.04357879,
                            0.15144454], dtype=np.float32),
    'hammer-cloned-v1': np.array([0.09446682, 0.12811361, 0.14943859, 0.32549474, 0.15009849,
                            0.22664358, 0.43278834, 0.4450162 , 0.07950662, 0.50149226,
                            0.41779372, 0.48838025, 0.07082102, 0.3138654 , 0.541041  ,
                            0.61226505, 0.11463427, 0.10823358, 0.5792356 , 0.5090002 ,
                            0.552108  , 0.41924292, 0.3296483 , 0.07030655, 0.13369101,
                            0.34482798, 0.02755001, 0.3878687 , 0.230923  , 0.11205775,
                            0.4796028 , 0.5171849 , 0.43796498, 0.07233379, 0.01584771,
                            0.05312698, 0.08776198, 0.02913771, 0.076055  , 0.19378507,
                            0.26423317, 0.11205021, 0.02569026, 0.00997516, 0.04284835,
                            0.15732376], dtype=np.float32),
    'hammer-human-v1': np.array([0.09426026, 0.11650437, 0.16855277, 0.24737091, 0.08076561,
                            0.1692703 , 0.3245119 , 0.34763753, 0.06869683, 0.39420107,
                            0.24530101, 0.32784995, 0.06465349, 0.24174428, 0.3720447 ,
                            0.4433174 , 0.10095961, 0.08186539, 0.43993714, 0.30670655,
                            0.36489284, 0.17135292, 0.1994225 , 0.05170865, 0.08548421,
                            0.28585455, 0.03162427, 0.5165965 , 0.28239927, 0.12104785,
                            0.6120028 , 0.6955253 , 0.5263283 , 0.07003386, 0.01278219,
                            0.05479468, 0.08167323, 0.01777809, 0.07340474, 0.22577378,
                            0.28040496, 0.12179064, 0.02947248, 0.01145806, 0.04237039,
                            0.21807241], dtype=np.float32),
    'pen-human-v1': np.array([0.2288434 , 0.19438428, 0.23877755, 0.39018843, 0.5090178 ,
                            0.5881102 , 0.22488439, 0.4698443 , 0.46232897, 0.54159117,
                            0.22329396, 0.50678736, 0.23204526, 0.26279572, 0.19151029,
                            0.32532278, 0.2339986 , 0.33327532, 0.30772808, 0.5980621 ,
                            0.44361007, 0.12195569, 0.27564797, 0.6955531 , 0.0202796 ,
                            0.01917351, 0.01625155, 0.09951965, 0.0534314 , 0.12776887,
                            2.0345466 , 1.4078845 , 1.7667896 , 0.46726185, 0.41181552,
                            0.23089927, 0.52989966, 0.45330358, 0.16078964, 0.0202796 ,
                            0.01917351, 0.01625154, 0.36045054, 0.26870424, 0.24048913],
                            dtype=np.float32),
    'pen-expert-v1': np.array([0.22564071, 0.2536596 , 0.1309052 , 0.44381452, 0.33928806,
                            0.3462924 , 0.17974168, 0.41262582, 0.27038267, 0.28014404,
                            0.16526629, 0.20772415, 0.4077929 , 0.38338217, 0.12624983,
                            0.1793428 , 0.30329856, 0.3289228 , 0.36605328, 0.41903275,
                            0.36050355, 0.12148733, 0.20824794, 0.0761395 , 0.02506505,
                            0.024974  , 0.02103743, 0.19338287, 0.10271604, 0.15079348,
                            3.2440488 , 2.2152739 , 2.6227388 , 0.52159655, 0.47579706,
                            0.29154044, 0.52833927, 0.44763857, 0.16727895, 0.02506505,
                            0.02497387, 0.02103735, 0.4374519 , 0.2481454 , 0.26887354],
                            dtype=np.float32),
    'pen-cloned-v1': np.array([0.23380263, 0.21594295, 0.27230045, 0.47962892, 0.5027729 ,
                            0.58453554, 0.245444  , 0.5509231 , 0.4873734 , 0.556084  ,
                            0.22388855, 0.54242873, 0.22781217, 0.2552318 , 0.18508205,
                            0.3192119 , 0.28577328, 0.3859627 , 0.37233433, 0.63326925,
                            0.4665397 , 0.12341399, 0.33059433, 0.70421964, 0.02237997,
                            0.01913552, 0.0161362 , 0.13506924, 0.08055543, 0.1661533 ,
                            2.6085162 , 1.8469586 , 2.3877623 , 0.47131893, 0.39813814,
                            0.2735479 , 0.5273747 , 0.45376557, 0.16298194, 0.02237997,
                            0.01913705, 0.01613049, 0.4614448 , 0.30395198, 0.28503677],
                            dtype=np.float32),
    'door-expert-v1': np.array([0.1312395 , 0.29754943, 0.4822608 , 0.07597148, 0.23036589,
                            0.14408533, 0.24664856, 0.25111264, 0.30339003, 0.16126017,
                            0.31323907, 0.15186583, 0.21536936, 0.17463547, 0.24667273,
                            0.21432276, 0.26025635, 0.09340608, 0.18070869, 0.21306361,
                            0.2382328 , 0.32907414, 0.33892077, 0.2241774 , 0.05194201,
                            0.10459563, 0.2779769 , 0.57595193, 0.60536045, 0.14120868,
                            0.1619112 , 0.04579233, 0.20419657, 0.13328506, 0.0548051 ,
                            0.08744236, 0.08282492, 0.04975131, 0.8764757 ], dtype=np.float32),
    'door-cloned-v1': np.array([0.37278736, 0.3416185 , 0.9743331 , 0.1508341 , 0.32669413,
                            0.18619697, 0.3191773 , 0.27390262, 0.28689006, 0.13367087,
                            0.43019482, 0.28111982, 0.29771605, 0.14918491, 0.2968908 ,
                            0.33502334, 0.37180015, 0.12605248, 0.1398716 , 0.26903448,
                            0.31462348, 0.34625337, 0.51876324, 0.3386034 , 0.10925347,
                            0.18372189, 0.34436008, 0.7538017 , 0.41952375, 0.17079677,
                            0.23025078, 0.12347494, 0.13716894, 0.12682295, 0.07120282,
                            0.19815719, 0.23103096, 0.12195285, 0.6396361 ], dtype=np.float32),
    'door-human-v1': np.array([0.16043214, 0.29327205, 0.64506614, 0.13954635, 0.30051896,
                            0.09372026, 0.2384739 , 0.3016056 , 0.33230054, 0.09809907,
                            0.39594185, 0.2375774 , 0.29337883, 0.1149461 , 0.29569456,
                            0.27664554, 0.33026347, 0.1284557 , 0.11966853, 0.2645231 ,
                            0.29888287, 0.35146675, 0.25298202, 0.27249536, 0.06896636,
                            0.11780184, 0.32217786, 0.7686812 , 0.5361365 , 0.13813604,
                            0.1914807 , 0.06346615, 0.1800045 , 0.15855761, 0.08166543,
                            0.11510423, 0.11384048, 0.05282273, 0.8435745 ], dtype=np.float32),
    
    'antmaze-umaze-v0': np.array([2.7841597 , 3.1524756 , 0.15707533, 0.41068196, 0.3299068 ,
                        0.34336352, 0.3981981 , 0.4536745 , 0.27702054, 0.42629424,
                        0.3026552 , 0.4286297 , 0.26848033, 0.43428224, 0.2868567 ,
                        0.81595963, 0.7459659 , 0.6922098 , 1.0527691 , 1.0722555 ,
                        1.0846906 , 2.4674442 , 1.8193856 , 2.7186642 , 1.919421  ,
                        2.7247536 , 1.7710892 , 2.4673977 , 1.699065  ], dtype=np.float32),
    'antmaze-umaze-diverse-v0': np.array([2.372928  , 1.6758871 , 0.16025287, 0.44831026, 0.36748356,
                        0.3773789 , 0.37907603, 0.45711255, 0.27256522, 0.4299881 ,
                        0.3134074 , 0.42715394, 0.26815704, 0.43632862, 0.28320602,
                        0.69428796, 0.6856849 , 0.6578312 , 0.96919024, 1.011982  ,
                        1.0464758 , 2.3567326 , 1.6925623 , 2.5428333 , 1.8538938 ,
                        2.6217716 , 1.5935259 , 2.3163853 , 1.5101402 ], dtype=np.float32),
    'antmaze-medium-play-v0': np.array([6.9409256 , 6.0889077 , 0.15416554, 0.41542804, 0.34322828,
                        0.35271874, 0.558137  , 0.44027138, 0.2655189 , 0.43432948,
                        0.27764744, 0.443216  , 0.3060495 , 0.4479894 , 0.26968703,
                        0.657666  , 0.6781428 , 0.6314491 , 0.9708031 , 1.005103  ,
                        1.0717415 , 2.347223  , 1.7079054 , 2.5089297 , 1.6055804 ,
                        2.5043242 , 1.7140281 , 2.3718727 , 1.6070359 ], dtype=np.float32),
    'antmaze-medium-diverse-v0': np.array([7.148001  , 6.11908   , 0.15348274, 0.40849632, 0.3444174 ,
                        0.3437727 , 0.5428598 , 0.43958494, 0.2636635 , 0.43550456,
                        0.2782416 , 0.44197184, 0.30913386, 0.44813797, 0.2637147 ,
                        0.6733229 , 0.6925437 , 0.6411779 , 0.9806585 , 1.0178717 ,
                        1.0748397 , 2.3645935 , 1.7411717 , 2.5634809 , 1.5948079 ,
                        2.5270114 , 1.7361785 , 2.3927815 , 1.6380483 ], dtype=np.float32),
    'antmaze-large-play-v0': np.array([9.599715  , 7.9831104 , 0.151978  , 0.4317991 , 0.3427903 ,
                        0.34661385, 0.54751474, 0.44594207, 0.26593977, 0.4358878 ,
                        0.28140435, 0.44062746, 0.29841554, 0.4468854 , 0.2769293 ,
                        0.7023499 , 0.7141133 , 0.62776345, 0.9663746 , 0.9844131 ,
                        1.0360646 , 2.3159544 , 1.7004626 , 2.533098  , 1.5907651 ,
                        2.476514  , 1.7181065 , 2.3599467 , 1.5965089 ], dtype=np.float32),
    'antmaze-large-diverse-v0': np.array([9.836868  , 8.130799  , 0.15047121, 0.42086127, 0.34470838,
                        0.3289304 , 0.55345255, 0.4434752 , 0.26641694, 0.43648306,
                        0.27854672, 0.44026217, 0.29779753, 0.44683772, 0.27626017,
                        0.70078623, 0.7206956 , 0.63304734, 0.97288615, 0.9946103 ,
                        1.0464675 , 2.338309  , 1.7254742 , 2.5501468 , 1.619719  ,
                        2.5054643 , 1.7285796 , 2.371646  , 1.6210179 ], dtype=np.float32),
    'relocate-expert-v1': np.array([0.05242327, 0.00909312, 0.11706813, 0.15960898, 0.17658095,
                        0.05540495, 0.04087421, 0.07415607, 0.10803272, 0.1257055 ,
                        0.21177861, 0.31436393, 0.06363665, 0.16126148, 0.2252681 ,
                        0.2391894 , 0.06737483, 0.11314694, 0.23094605, 0.2580871 ,
                        0.1323327 , 0.07667726, 0.21041295, 0.28014505, 0.30092657,
                        0.356613  , 0.23542054, 0.06983565, 0.11193044, 0.14272173,
                        0.02847274, 0.07614802, 0.06309225, 0.06374658, 0.08669396,
                        0.07123713, 0.07141551, 0.09505685, 0.10646269], dtype=np.float32),
    'relocate-cloned-v1': np.array([0.1223969 , 0.03135836, 0.22973756, 0.4108566 , 0.39967954,
                        0.30817884, 0.07637567, 0.22099787, 0.15159456, 0.26748857,
                        0.39795253, 0.4187784 , 0.10917655, 0.41580123, 0.36419752,
                        0.4001772 , 0.10443798, 0.28688154, 0.38392055, 0.42519712,
                        0.18545558, 0.13135292, 0.37909064, 0.4826789 , 0.51961553,
                        0.61079013, 0.3238717 , 0.07468764, 0.19744165, 0.32152864,
                        0.12641819, 0.29583058, 0.1636246 , 0.15539002, 0.34412444,
                        0.15957327, 0.14694941, 0.17627884, 0.12866928], dtype=np.float32),
    'relocate-human-v1': np.array([0.05677237, 0.00934592, 0.13755359, 0.2280693 , 0.21156223,
                        0.0918197 , 0.03572299, 0.13235454, 0.11696675, 0.15262286,
                        0.31408983, 0.3170375 , 0.05001815, 0.32921422, 0.22389123,
                        0.2465277 , 0.0478158 , 0.22030474, 0.30171585, 0.33552513,
                        0.10327166, 0.07182803, 0.27042204, 0.43248776, 0.46696645,
                        0.47652316, 0.25876543, 0.04733807, 0.11880325, 0.21227878,
                        0.04431649, 0.08891159, 0.0877082 , 0.12200617, 0.14410302,
                        0.109424  , 0.12896815, 0.15669447, 0.1155197 ], dtype=np.float32)
}

def get_obs_mean_std(env_name):
    assert env_name in obs_std_dict.keys(), 'No such environment'
    return obs_mean_dict[env_name], obs_std_dict[env_name]