import argparse
import tensorflow as tf
import numpy as np
from matplotlib import pyplot as plt
from tensorflow.examples.tutorials.mnist import input_data
import os 
import multiprocessing as mp
from qnetwork import *
from utils import *
import pandas as pd
from sklearn.metrics import roc_auc_score, average_precision_score
import scipy.stats as stats
import random

rnn = tf.contrib.rnn
slim = tf.contrib.slim

parser = argparse.ArgumentParser()
parser.add_argument("-no_gpu", dest='no_gpu', action='store_true', help="Train w/o using GPUs")
parser.add_argument("-gpu", "--gpu_idx", type=int, help="Select which GPU to use DEFAULT=0", default=0)
parser.add_argument("-lr_prediction_model", type=float, help="Set learning rate for training the MLP prediction model DEFAULT=0.001", default=0.001)
parser.add_argument("-decay_step", type=int, help="Set exponential decay step DEFAULT=750", default=750)
parser.add_argument("-decay_rate", type=float, help="Set exponential decay rate DEFAULT=0.8", default=0.8)
parser.add_argument("-training_steps", type=int, help="Set max number of training epochs DEFAULT=10000", default=10000)
parser.add_argument("-seed", type=int, help="Set random seed", default=2599)


if __name__ == '__main__':
    args = parser.parse_args()
    if not args.no_gpu:
        os.environ["CUDA_VISIBLE_DEVICES"] = str(args.gpu_idx)
        session_config = tf.ConfigProto(log_device_placement=False)
        session_config.gpu_options.allow_growth = True
    else:
        os.environ["CUDA_VISIBLE_DEVICES"] = ""
        session_config = tf.ConfigProto(log_device_placement=False)
    SEED = args.seed
    np.random.seed(SEED)
    tf.set_random_seed(SEED)
    random.seed(SEED)

    if not os.path.exists("./saved_model"):
            os.mkdir("./saved_model")
    if not os.path.exists("./stats"):
            os.mkdir("./stats")
    if not os.path.exists("./stats/rl_log"):
            os.mkdir("./stats/rl_log")

    mnist = input_data.read_data_sets("/tmp/data/", one_hot=True)
    mnist_train_imgs = mnist.train.images
    mnist_train_labels = mnist.train.labels
    mnist_test_imgs = mnist.test.images
    mnist_test_labels = mnist.test.labels
    data_label_test = mnist_test_labels

    # How much pixels are masked off
    MASK_SIZE = 700

    # Load masked data
    data_train = np.loadtxt("./data/mnist_all_train_"+str(MASK_SIZE)+".txt").reshape(-1,784).astype(np.float32)
    data_mask_train = np.isnan(data_train).astype(np.int)
    data_train[np.where(data_mask_train==1)] = 0.

    data_test = np.loadtxt("./data/mnist_all_test_"+str(MASK_SIZE)+".txt").reshape(-1,784).astype(np.float32)
    data_mask_test = np.isnan(data_test).astype(np.int)
    data_test[np.where(data_mask_test==1)] = 0.

    data_label_train = mnist.train.labels.astype(np.float32)
    data_label_test = mnist.test.labels.astype(np.float32)


    np.random.seed(SEED)
    tf.set_random_seed(SEED)
    random.seed(SEED)


    # Prediction Model Parameters
    start_learning_rate = args.lr_prediction_model
    decay_step = args.decay_step
    decay_rate = args.decay_rate


    training_steps = args.training_steps
    batch_size = 128

    num_input = 28
    timesteps = 28 
    num_classes = 10

    display_step = 10

    weights = [500, 500]

    gpu = 0

    graph = tf.Graph()

    file_appendix = "MNIST_90_missing_MLP_GIL-H_" + str(start_learning_rate) + "_" + str(decay_step) + "_" + str(decay_rate)


    def build_net(x, is_training=True, reuse=tf.AUTO_REUSE, graph=graph):

        with graph.as_default():

            with tf.variable_scope("NN", reuse=tf.AUTO_REUSE) as scope:
                with slim.arg_scope([slim.fully_connected], 
                                        activation_fn=tf.nn.relu,
                                        weights_initializer=tf.random_uniform_initializer(0.001, 0.01),
                                        weights_regularizer=slim.l2_regularizer(0.01),
                                        biases_regularizer=slim.l2_regularizer(0.01),
                                        normalizer_fn = None,
                                        normalizer_params = {"is_training": is_training},
                                        reuse = reuse,
                                        scope = scope):

                    fc1 = slim.fully_connected(x, weights[0], scope='fc1')
                    fc2 = slim.fully_connected(fc1, weights[1], scope='fc2')
                    logits = slim.fully_connected(fc2,num_classes,activation_fn=None, weights_regularizer=None, normalizer_fn=None, scope='logits')
                    pred = slim.softmax(logits, scope='pred')

                    return logits, pred


    def gen_train():
        for i in range(mnist_train_imgs.shape[0]//batch_size):
            out = np.copy(mnist_train_imgs[i*batch_size:i*batch_size+batch_size])
            mask = np.asarray([np.random.choice(range(784),MASK_SIZE,replace=False) for _ in range(batch_size)])
            mask = np.repeat(np.arange(batch_size),MASK_SIZE).reshape(batch_size,-1).astype(np.int), mask.astype(np.int)
            out[mask] = 0.
            yield out, mnist_train_labels[i*batch_size:i*batch_size+batch_size].astype(np.float32), mask


    def gen_test():
        for i in range(data_test.shape[0]):
            yield data_test[i], data_label_test[i], data_mask_test[i]


    with graph.as_default():

        dataset_train = tf.data.Dataset.from_generator(gen_train, (tf.float32, tf.float32, tf.int32), ([batch_size, 28*28],[batch_size, 10],[2,batch_size,MASK_SIZE])).repeat(1000)
        input_train, label_train, mask_train = dataset_train.make_one_shot_iterator().get_next()

        logits, prediction = build_net(input_train)

        all_test = data_test

        logits_final, pred_final = build_net(all_test, is_training=False)

        loss_op = tf.nn.softmax_cross_entropy_with_logits(logits=logits, labels=label_train) + tf.reduce_mean(tf.get_collection(tf.GraphKeys.REGULARIZATION_LOSSES))
        loss_mean = tf.reduce_min(loss_op, axis=0)
        learning_rate = tf.train.exponential_decay(start_learning_rate, tf.train.get_or_create_global_step(), decay_steps=decay_step, decay_rate=decay_rate)
        optimizer = tf.train.AdamOptimizer(learning_rate=learning_rate)

        update_ops = tf.get_collection(tf.GraphKeys.UPDATE_OPS)

        # Get the gradients following regular SGD solvers
        grads = tf.vectorized_map(lambda x: optimizer.compute_gradients(x, tf.trainable_variables()), loss_op)
        grads = [g[0] for g in grads]

        # Apply the simple heuristic to the gradients of the encoding layers
        fc1_grads_gather = tf.gather_nd(grads[0], tf.stack([mask_train[0],mask_train[1]],axis=-1))
        fc1_grads_update = tf.scatter_nd(indices=tf.stack([mask_train[0],mask_train[1]],axis=-1), updates=-fc1_grads_gather, shape=[batch_size, 28*28, weights[0]])
        grads[0] += fc1_grads_update

        grads = [tf.reduce_mean(g,axis=0) for g in grads]

        grads_update_op = optimizer.apply_gradients(zip(grads, tf.trainable_variables()))

        final_correct_pred = tf.equal(tf.argmax(pred_final, 1), tf.argmax(data_label_test, 1))
        final_accuracy = tf.reduce_mean(tf.cast(final_correct_pred, tf.float32))

        max_final_acc = tf.Variable(0, dtype=tf.float32, name="max_final_acc", trainable=False)
        assign_max_final_acc = max_final_acc.assign(final_accuracy)

        init = tf.global_variables_initializer()

        saver = tf.train.Saver()


    # Start training
    with tf.Session(config=session_config, graph=graph) as sess:
        sess.run(init)

        for step in range(1, training_steps+1):
            sess.run(grads_update_op)
            if step % display_step == 0 or step == 1:
                # Calculate batch loss and accuracy
                loss, acc = sess.run([loss_mean, final_accuracy])
                if acc > max_final_acc.eval():
                    sess.run(assign_max_final_acc)
                    saver.save(sess, "./saved_model/"+file_appendix+"/best.ckpt")
                print "Step " + str(step) + ", Minibatch Loss= " + \
                      "{:.4f}".format(loss) + ", Training Accuracy= " + \
                      "{:.3f}".format(acc)  + ", Max Final Accuracy= ", "{:3f}".format(max_final_acc.eval())

        print "Optimization Finished!"

        print "Testing Accuracy:", sess.run(max_final_acc)
        with open("./stats/MNIST_90_missing_MLP_GIL-H.txt", "ab") as myfile:
            myfile.write("%.9f\t%i\t%.3f\t%i\t%i\t%.4f\n" %(start_learning_rate, decay_step, decay_rate, weights[0], weights[1], max_final_acc.eval()))

