import argparse
import tensorflow as tf
import numpy as np
from matplotlib import pyplot as plt
from tensorflow.examples.tutorials.mnist import input_data
import os 
import multiprocessing as mp
from qnetwork import *
from utils import *
import pandas as pd
from sklearn.metrics import roc_auc_score, average_precision_score
import scipy.stats as stats
import random

rnn = tf.contrib.rnn
slim = tf.contrib.slim

parser = argparse.ArgumentParser()
parser.add_argument("-no_gpu", dest='no_gpu', action='store_true', help="Train w/o using GPUs")
parser.add_argument("-gpu", "--gpu_idx", type=int, help="Select which GPU to use DEFAULT=0", default=0)
parser.add_argument("-ckpt_path", type=str, help="Path to the saved checkpoint")

if __name__ == '__main__':
    args = parser.parse_args()
    if not args.no_gpu:
        os.environ["CUDA_VISIBLE_DEVICES"] = str(args.gpu_idx)
        session_config = tf.ConfigProto(log_device_placement=False)
        session_config.gpu_options.allow_growth = True
    else:
        os.environ["CUDA_VISIBLE_DEVICES"] = ""
        session_config = tf.ConfigProto(log_device_placement=False)

    mnist = input_data.read_data_sets("/tmp/data/", one_hot=True)
    mnist_train_imgs = mnist.train.images
    mnist_train_labels = mnist.train.labels
    mnist_test_imgs = mnist.test.images
    mnist_test_labels = mnist.test.labels
    data_label_test = mnist_test_labels

    # How much pixels are masked off
    MASK_SIZE = 700

    # Load masked data
    data_train = np.loadtxt("./data/mnist_all_train_"+str(MASK_SIZE)+".txt").reshape(-1,784).astype(np.float32)
    data_mask_train = np.isnan(data_train).astype(np.int)
    data_train[np.where(data_mask_train==1)] = 0.

    data_test = np.loadtxt("./data/mnist_all_test_"+str(MASK_SIZE)+".txt").reshape(-1,784).astype(np.float32)
    data_mask_test = np.isnan(data_test).astype(np.int)
    data_test[np.where(data_mask_test==1)] = 0.

    data_label_train = mnist.train.labels.astype(np.float32)
    data_label_test = mnist.test.labels.astype(np.float32)


    batch_size = 128

    num_input = 28
    timesteps = 28 
    num_classes = 10

    display_step = 10

    weights = [500, 500]

    gpu = 0

    graph = tf.Graph()


    def build_net(x, is_training=True, reuse=tf.AUTO_REUSE, graph=graph):

        with graph.as_default():

            with tf.variable_scope("NN", reuse=tf.AUTO_REUSE) as scope:
                with slim.arg_scope([slim.fully_connected], 
                                        activation_fn=tf.nn.relu,
                                        weights_initializer=tf.random_uniform_initializer(0.001, 0.01),
                                        weights_regularizer=slim.l2_regularizer(0.01),
                                        biases_regularizer=slim.l2_regularizer(0.01),
                                        normalizer_fn = None,
                                        normalizer_params = {"is_training": is_training},
                                        reuse = reuse,
                                        scope = scope):

                    fc1 = slim.fully_connected(x, weights[0], scope='fc1')
                    fc2 = slim.fully_connected(fc1, weights[1], scope='fc2')
                    logits = slim.fully_connected(fc2,num_classes,activation_fn=None, weights_regularizer=None, normalizer_fn=None, scope='logits')
                    pred = slim.softmax(logits, scope='pred')

                    return logits, pred, fc1


    def gen_train():
        for i in range(mnist_train_imgs.shape[0]):
            out = np.copy(mnist_train_imgs[i])
            mask_idx = np.random.choice(range(784),MASK_SIZE,replace=False)
            out[mask_idx] = np.nan
            mask = np.isnan(out).astype(np.int)
            out[mask_idx] = 0.
            yield out, mnist_train_labels[i].astype(np.float32), mask


    def gen_test():
        for i in range(data_test.shape[0]):
            yield data_test[i], data_label_test[i], data_mask_test[i]


    with graph.as_default():

        dataset_test = tf.data.Dataset.from_generator(gen_test, (tf.float32, tf.float32, tf.int32), ([784],[ 10],[784])).repeat(30000).batch(mnist_test_imgs.shape[0])
        input_test, label_test, mask_test = dataset_test.make_one_shot_iterator().get_next()

        all_test = data_test

        logits_final, pred_final, _ = build_net(input_test, is_training=False)

        final_correct_pred = tf.equal(tf.argmax(pred_final, 1), tf.argmax(label_test, 1))
        final_accuracy = tf.reduce_mean(tf.cast(final_correct_pred, tf.float32))
        final_kld = tf.keras.losses.KLDivergence()(pred_final, label_test)

        max_final_acc = tf.Variable(0, dtype=tf.float32, name="max_final_acc", trainable=False)
        assign_max_final_acc = max_final_acc.assign(final_accuracy)

        saver = tf.train.Saver()


    # Start training
    with tf.Session(config=session_config, graph=graph) as sess:
        saver.restore(sess, os.path.join(args.ckpt_path, "best.ckpt"))
        print "Accuracy: ", sess.run(final_accuracy)


        