---
license: cc-by-nc-4.0
task_categories:
- text-classification
language:
- en
tags:
- safe
- safety
- ai-safety
- moderation
- rejection-sampling
- llm
- lm
- human-feedback
size_categories:
- n<1K
---

# Dataset Card for BeaverTails-Evaluation

BeaverTails is an AI safety-focused collection comprising a series of datasets.
This repository contains test prompts specifically designed for evaluating language model safety.
It is important to note that although each prompt can be connected to multiple categories, only one category is labeled for each prompt.

The 14 harm categories are defined as follows:

1. **Animal Abuse:** This involves any form of cruelty or harm inflicted on animals, including physical abuse, neglect, or any behavior that causes distress or harm to an animal. It also includes content that promotes such behavior.
1. **Child Abuse:** This encompasses any form of physical, emotional, or sexual abuse directed toward children. It can also include neglect, exploitation, or any behavior that harms a child or violates their rights. Content that promotes or glorifies such behavior also falls under this category.
1. **Controversial Topics, Politics:** This refers to discussions or statements related to controversial topics, political ideologies, or sensitive issues that could lead to disagreement or conflict. These topics can be divisive and could potentially cause harm if not handled respectfully and thoughtfully.
1. **Discrimination, Stereotype, Injustice:** Discrimination refers to treating people unfairly or unequally based on their personal characteristics or affiliations such as race, age, gender, religion, etc. Stereotyping involves holding simplified and generalized beliefs about particular groups, which often leads to prejudices and discrimination. Injustice pertains to unfair treatment or violation of the rights of individuals or groups.
1. **Drug Abuse, Weapons, Banned Substance:** This category includes the misuse or abuse of illegal drugs, prescription drugs, or any other banned substances. It also involves the unauthorized or illegal possession, use, or trade of weapons.
1. **Financial Crime, Property Crime, Theft:** This includes all forms of illegal activities that lead to financial loss such as fraud, embezzlement, money laundering, bribery, and other forms of corruption. Property crime and theft involve the act of taking someone's property without their consent.
1. **Hate Speech, Offensive Language:** This category encompasses any form of communication or content that expresses intense hostility or violence towards an individual or group based on aspects like race, religion, ethnicity, nationality, gender, sexual orientation, or any other defining characteristics. This also includes language that is considered vulgar, crude, or offensive.
1. **Misinformation Regarding ethics, laws, and safety:** This category involves the spreading of incorrect or misleading information related to ethical issues, laws, regulations, or any matter related to safety. Misinformation can cause harm by influencing people's beliefs or actions negatively.
1. **Non-Violent Unethical Behavior:** This refers to any behavior that is morally or ethically wrong, but does not involve violence. Examples can include dishonest behaviors like lying, cheating, deceiving, spreading rumors, betraying trust, or any other form of unethical conduct.
1. **Privacy Violation:** This refers to actions that invade an individual's privacy, such as unauthorized access, use, disclosure, or collection of personal data. It also includes stalking, doxing, or any other form of intrusion into someone's personal life without their consent.
1. **Self-Harm:** This includes any form of self-inflicted harm, whether physical or emotional, or any content that promotes, glorifies, or encourages self-harm. This can also include discussions of suicidal thoughts or plans.
1. **Sexually Explicit, Adult Content:** This category includes any content that depicts explicit sexual activities or adult themes that are considered inappropriate or offensive. This can include pornography, explicit sexual text or messages, and any other form of sexually explicit material.
1. **Terrorism, Organized Crime:** This pertains to any form of content or action related to terrorism or organized crime, including endorsing or promoting terrorist activities, participating in organized criminal activities, or spreading propaganda for such groups.
1. **Violence, Aiding and Abetting, Incitement:** This involves any form of physical harm, threat, or violent behavior towards individuals or groups. Aiding and abetting refers to the act of helping, supporting, or encouraging such violent behaviors or illegal activities. Incitement pertains to the act of provoking or stirring up harmful, violent, or illegal actions.

**Disclaimer**: The BeaverTails dataset and its family contain content that may be offensive or upsetting.
Topics covered in the dataset include, but are not limited to, discriminatory language and discussions of abuse, violence, self-harm, exploitation, and other potentially distressing subject matter.
Please engage with the dataset responsibly and in accordance with your own personal risk tolerance.
The dataset is intended for research purposes, specifically for research aimed at creating safer and less harmful AI systems.
The views and opinions expressed in the dataset do not represent the views of the PKU-Alignment Team or any of its members.
It is important to emphasize that the dataset should not be used for training dialogue agents, as doing so may likely result in harmful model behavior.
The primary objective of this dataset is to facilitate research that could minimize or prevent the harm caused by AI systems.

## Usage

The code snippet below demonstrates how to load the evaluation dataset:

```python
from datasets import load_dataset

# Load the whole dataset
dataset = load_dataset('PKU-Alignment/BeaverTails-Evaluation')

# Load only the v1 dataset
round0_dataset = load_dataset('PKU-Alignment/BeaverTails', data_dir='v1')
```

## Paper

You can find more information in our paper.

- **Dataset Paper:** <https://arxiv.org/abs/2307.04657>

## Contact

The original authors host this dataset on GitHub here: https://github.com/PKU-Alignment/beavertails

## License

BeaverTails dataset and its family are released under the CC BY-NC 4.0 License.
