class EasyList:
    def __init__(self, initial_items=None):
        self.items = initial_items if initial_items is not None else list()

    def add(self, item):
        self.items.append(item)

    def remove(self, item):
        if item in self.items:
            self.items.remove(item)

    def get(self, index):
        if 0 <= index < len(self.items):
            return self.items[index]
        return None

    def size(self):
        return len(self.items)

    def clear(self):
        self.items = []

    def sort(self):
        self.items.sort()

    def reverse(self):
        self.items.reverse()

    def contains(self, item):
        return item in self.items

    def extend(self, other):
        self.items.extend(other)

    def index_of(self, item):
        try:
            return self.items.index(item)
        except ValueError:
            return -1

    def insert(self, index, item):
        self.items.insert(index, item)

    def pop(self, index=-1):
        if 0 <= index < len(self.items):
            return self.items.pop(index)
        return None

    def replace(self, index, item):
        if 0 <= index < len(self.items):
            self.items[index] = item
        else:
            print("Index out of bounds") 

    def __str__(self):
        return str(self.items)
    