import re

def parse_requirements(input_string):
    input_string = input_string.split('#')[0].strip()
    
    pattern = r'^([\w\-_\.]+(\[[\w\-,_\.]+\])?)\s*((?:[><=!~]{1,2}\s*[\d\w\.\-\+]+(?:\s*,\s*)?)*)$'
    
    matches = re.match(pattern, input_string)
    
    if matches:
        package_name = matches.group(1)
        version_constraints = matches.group(3).strip() if matches.group(3) else None
        return package_name, version_constraints
    else:
        return None, None

if __name__ == '__main__':
    test_cases = [
        "numpy>2.0  <3.0",
        "numpy > 2.0, < 3.0",
        "numpy>=1.18,<1.19",
        "pandas==1.1.4",
        "scikit-learn!=0.20.3",
        "tensorflow >=2.2.0, !=2.5.0",
        "opentelemetry-instrumentation-celery==0.26b1",
        "opentelemetry-semantic-conventions==0.26b1",
        "opentelemetry-instrumentation-elasticsearch==0.26b1",
        "typing_extensions==3.7.4.3",
        "blueapps[opentelemetry]==4.4.2"
    ]

    for test in test_cases:
        print(parse_requirements(test))
